/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.headless;

import java.util.List;
import java.util.UUID;
import javax.jdo.PersistenceManagerFactory;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.AppManifest2;
import org.apache.isis.applib.AppManifestAbstract2;
import org.apache.isis.applib.Module;
import org.apache.isis.applib.fixtures.TickingFixtureClock;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.services.jdosupport.IsisJdoSupport;
import org.apache.isis.applib.services.metamodel.MetaModelService4;
import org.apache.isis.applib.services.registry.ServiceRegistry2;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.runtime.headless.IsisSystem;
import org.apache.isis.core.runtime.headless.logging.LogConfig;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.objectstore.jdo.datanucleus.IsisConfigurationForJdoIntegTests;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisSystemBootstrapper {
    private static final Logger LOG = LoggerFactory.getLogger(IsisSystemBootstrapper.class);
    private static ThreadLocal<AppManifest2> isftAppManifest = new ThreadLocal();
    private final LogConfig logConfig;
    private final AppManifest2 appManifest2;

    public IsisSystemBootstrapper(LogConfig logConfig, Module module) {
        this(logConfig, AppManifestAbstract2.Builder.forModule((Module)module).build());
    }

    public IsisSystemBootstrapper(LogConfig logConfig, AppManifest2 appManifest2) {
        this.logConfig = logConfig;
        this.appManifest2 = appManifest2;
    }

    public AppManifest2 getAppManifest2() {
        return this.appManifest2;
    }

    public Module getModule() {
        return this.appManifest2.getModule();
    }

    public IsisSystem bootstrapIfRequired() {
        this.bootstrapUsing(this.appManifest2);
        return IsisSystem.get();
    }

    public void setupModuleRefData() {
        MetaModelService4 metaModelService4 = IsisSystemBootstrapper.lookupService(MetaModelService4.class);
        FixtureScript refDataSetupFixture = metaModelService4.getAppManifest2().getRefDataSetupFixture();
        this.runFixtureScript(refDataSetupFixture);
    }

    private void bootstrapUsing(AppManifest2 appManifest2) {
        SystemState systemState = IsisSystemBootstrapper.determineSystemState((AppManifest)appManifest2);
        switch (systemState) {
            case BOOTSTRAPPED_SAME_MODULES: {
                break;
            }
            case BOOTSTRAPPED_DIFFERENT_MODULES: {
                throw new RuntimeException("Bootstrapping different modules is not yet supported");
            }
            case NOT_BOOTSTRAPPED: {
                long t0 = System.currentTimeMillis();
                IsisSystemBootstrapper.setupSystem(appManifest2);
                long t1 = System.currentTimeMillis();
                this.log("##########################################################################");
                this.log("# Bootstrapped in " + (t1 - t0) + " millis");
                this.log("##########################################################################");
                TickingFixtureClock.replaceExisting();
            }
        }
    }

    private static SystemState determineSystemState(AppManifest appManifest) {
        IsisSystem isft = IsisSystem.getElseNull();
        if (isft == null) {
            return SystemState.NOT_BOOTSTRAPPED;
        }
        AppManifest appManifestFromPreviously = (AppManifest)isftAppManifest.get();
        return IsisSystemBootstrapper.haveSameModules(appManifest, appManifestFromPreviously) ? SystemState.BOOTSTRAPPED_SAME_MODULES : SystemState.BOOTSTRAPPED_DIFFERENT_MODULES;
    }

    static boolean haveSameModules(AppManifest m1, AppManifest m2) {
        List m2Modules;
        List m1Modules = m1.getModules();
        return m1Modules.containsAll(m2Modules = m2.getModules()) && m2Modules.containsAll(m1Modules);
    }

    private static IsisSystem setupSystem(AppManifest2 appManifest2) {
        IsisConfigurationForJdoIntegTests configuration = new IsisConfigurationForJdoIntegTests();
        configuration.putDataNucleusProperty("javax.jdo.option.ConnectionURL", "jdbc:hsqldb:mem:test-" + UUID.randomUUID().toString());
        Object isftBuilder = ((IsisSystem.Builder)((IsisSystem.Builder)new IsisSystem.Builder().withLoggingAt(Level.INFO)).with((AppManifest)appManifest2)).with((IsisConfiguration)configuration);
        Object isft = ((IsisSystem.Builder)isftBuilder).build();
        ((IsisSystem)isft).setUpSystem();
        IsisSystem.set(isft);
        isftAppManifest.set(appManifest2);
        return isft;
    }

    public void injectServicesInto(Object object) {
        IsisSystemBootstrapper.lookupService(ServiceRegistry2.class).injectServicesInto(object);
    }

    private static void teardownSystem() {
        IsisSessionFactory isisSessionFactory = IsisSystemBootstrapper.lookupService(IsisSessionFactory.class);
        IsisJdoSupport isisJdoSupport = IsisSystemBootstrapper.lookupService(IsisJdoSupport.class);
        PersistenceManagerFactory pmf = isisJdoSupport.getJdoPersistenceManager().getPersistenceManagerFactory();
        isisSessionFactory.destroyServicesAndShutdown();
        pmf.close();
        IsisContext.testReset();
    }

    public void tearDownAllModules() {
        MetaModelService4 metaModelService4 = IsisSystemBootstrapper.lookupService(MetaModelService4.class);
        FixtureScript fixtureScript = metaModelService4.getAppManifest2().getTeardownFixture();
        this.runFixtureScript(fixtureScript);
    }

    private void runFixtureScript(FixtureScript ... fixtureScriptList) {
        FixtureScripts fixtureScripts = IsisSystemBootstrapper.lookupService(FixtureScripts.class);
        fixtureScripts.runFixtureScript(fixtureScriptList);
    }

    private static IsisSystem getIsisSystem() {
        return IsisSystem.get();
    }

    private static <T> T lookupService(Class<T> serviceClass) {
        return IsisSystemBootstrapper.getIsisSystem().getService(serviceClass);
    }

    private void log(String message) {
        switch (this.logConfig.getTestLoggingLevel()) {
            case ERROR: {
                LOG.error(message);
                break;
            }
            case WARN: {
                LOG.warn(message);
                break;
            }
            case INFO: {
                LOG.info(message);
                break;
            }
            case DEBUG: {
                LOG.debug(message);
                break;
            }
            case TRACE: {
                LOG.trace(message);
            }
        }
    }

    static enum SystemState {
        NOT_BOOTSTRAPPED,
        BOOTSTRAPPED_SAME_MODULES,
        BOOTSTRAPPED_DIFFERENT_MODULES;

    }
}

