/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.headless;

import com.google.common.base.Joiner;
import java.util.Set;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.applib.fixtures.InstallableFixture;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.fixtures.FixturesInstallerDelegate;
import org.apache.isis.core.runtime.headless.IsisComponentProviderDefault;
import org.apache.isis.core.runtime.headless.auth.AuthenticationRequestNameOnly;
import org.apache.isis.core.runtime.logging.IsisLoggingConfigurer;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSessionFactoryBuilder;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProvider;
import org.apache.log4j.Level;

public class IsisSystem {
    protected static ThreadLocal<IsisSystem> ISFT = new ThreadLocal();
    protected final AppManifest appManifestIfAny;
    protected final IsisConfiguration configurationOverride;
    protected final AuthenticationRequest authenticationRequestIfAny;
    protected AuthenticationSession authenticationSession;
    private Level level = Level.INFO;
    protected IsisComponentProvider componentProvider;
    protected IsisSessionFactory isisSessionFactory;

    public static IsisSystem getElseNull() {
        return ISFT.get();
    }

    public static IsisSystem get() {
        IsisSystem isft = ISFT.get();
        if (isft == null) {
            throw new IllegalStateException("No IsisSystem available on thread; call #set(IsisSystem) first");
        }
        return isft;
    }

    public static void set(IsisSystem isft) {
        ISFT.set(isft);
    }

    public static Builder builder() {
        return new Builder();
    }

    protected IsisSystem(AppManifest appManifestIfAny, IsisConfiguration configurationOverride, AuthenticationRequest authenticationRequestIfAny) {
        this.appManifestIfAny = appManifestIfAny;
        this.configurationOverride = configurationOverride;
        this.authenticationRequestIfAny = authenticationRequestIfAny;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    IsisSystem setUpSystem() throws RuntimeException {
        try {
            this.initIfRequiredThenOpenSession();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    protected void initIfRequiredThenOpenSession() throws Exception {
        boolean firstTime;
        MetaModelInvalidException mmie = IsisContext.getMetaModelInvalidExceptionIfAny();
        if (mmie != null) {
            Set validationErrors = mmie.getValidationErrors();
            String validationMsg = Joiner.on((String)"\n").join((Iterable)validationErrors);
            throw new AssertionError((Object)validationMsg);
        }
        boolean bl = firstTime = this.isisSessionFactory == null;
        if (firstTime) {
            IsisLoggingConfigurer isisLoggingConfigurer = new IsisLoggingConfigurer(this.getLevel());
            isisLoggingConfigurer.configureLogging(".", new String[0]);
            this.componentProvider = new IsisComponentProviderDefault(this.appManifestIfAny, this.configurationOverride);
            IsisSessionFactoryBuilder isisSessionFactoryBuilder = new IsisSessionFactoryBuilder(this.componentProvider, DeploymentCategory.PRODUCTION, this.appManifestIfAny);
            FixtureClock.initialize();
            this.isisSessionFactory = isisSessionFactoryBuilder.buildSessionFactory();
            this.closeSession();
            MetaModelInvalidException ex = IsisContext.getMetaModelInvalidExceptionIfAny();
            if (ex != null) {
                IsisContext.testReset();
                Set validationErrors = ex.getValidationErrors();
                StringBuilder buf = new StringBuilder();
                for (String validationError : validationErrors) {
                    buf.append(validationError).append("\n");
                }
                throw new AssertionError((Object)("Metamodel is invalid: \n" + buf.toString()));
            }
        }
        AuthenticationManager authenticationManager = this.isisSessionFactory.getAuthenticationManager();
        this.authenticationSession = authenticationManager.authenticate(this.authenticationRequestIfAny);
        this.openSession();
    }

    public DomainObjectContainer getContainer() {
        return this.getService(DomainObjectContainer.class);
    }

    public IsisSessionFactory getIsisSessionFactory() {
        return this.isisSessionFactory;
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    public void nextSession() throws Exception {
        this.closeSession();
        this.openSession();
    }

    public void openSession() throws Exception {
        this.openSession(this.authenticationSession);
    }

    public void openSession(AuthenticationSession authenticationSession) throws Exception {
        this.isisSessionFactory.openSession(authenticationSession);
    }

    public void closeSession() throws Exception {
        if (this.isisSessionFactory.inSession()) {
            this.isisSessionFactory.closeSession();
        }
    }

    @Deprecated
    public void beginTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getCurrentTransaction();
        if (transaction == null) {
            this.startTransactionForUser(transactionManager);
            return;
        }
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case COMMITTED: 
            case ABORTED: {
                this.startTransactionForUser(transactionManager);
                break;
            }
            case IN_PROGRESS: {
                break;
            }
            case MUST_ABORT: {
                throw new AssertionError((Object)("Transaction is in state of '" + (Object)((Object)state) + "'"));
            }
            default: {
                throw new AssertionError((Object)("Unknown transaction state '" + (Object)((Object)state) + "'"));
            }
        }
    }

    private void startTransactionForUser(IsisTransactionManager transactionManager) {
        transactionManager.startTransaction();
        CommandContext commandContext = this.getService(CommandContext.class);
        Command command = commandContext.getCommand();
        command.setExecutor(Command.Executor.USER);
    }

    @Deprecated
    public void endTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getCurrentTransaction();
        if (transaction == null) {
            throw new AssertionError((Object)"No transaction exists");
        }
        transactionManager.endTransaction();
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case COMMITTED: {
                break;
            }
            case ABORTED: {
                break;
            }
            case IN_PROGRESS: {
                throw new AssertionError((Object)("Transaction is still in state of '" + (Object)((Object)state) + "'"));
            }
            case MUST_ABORT: {
                throw new AssertionError((Object)("Transaction is still in state of '" + (Object)((Object)state) + "'"));
            }
            default: {
                throw new AssertionError((Object)("Unknown transaction state '" + (Object)((Object)state) + "'"));
            }
        }
    }

    @Deprecated
    public void commitTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getCurrentTransaction();
        if (transaction == null) {
            throw new AssertionError((Object)"No transaction exists");
        }
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case COMMITTED: 
            case ABORTED: 
            case MUST_ABORT: {
                throw new AssertionError((Object)("Transaction is in state of '" + (Object)((Object)state) + "'"));
            }
            case IN_PROGRESS: {
                transactionManager.endTransaction();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown transaction state '" + (Object)((Object)state) + "'"));
            }
        }
    }

    @Deprecated
    public void abortTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getCurrentTransaction();
        if (transaction == null) {
            throw new AssertionError((Object)"No transaction exists");
        }
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case ABORTED: {
                break;
            }
            case COMMITTED: {
                throw new AssertionError((Object)("Transaction is in state of '" + (Object)((Object)state) + "'"));
            }
            case IN_PROGRESS: 
            case MUST_ABORT: {
                transactionManager.abortTransaction();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown transaction state '" + (Object)((Object)state) + "'"));
            }
        }
    }

    public <C> C getService(Class<C> serviceClass) {
        ServicesInjector servicesInjector = this.isisSessionFactory.getServicesInjector();
        return (C)servicesInjector.lookupServiceElseFail(serviceClass);
    }

    @Deprecated
    public void installFixtures(InstallableFixture ... fixtures) {
        FixturesInstallerDelegate fid = new FixturesInstallerDelegate(this.isisSessionFactory);
        for (InstallableFixture fixture : fixtures) {
            fid.addFixture(fixture);
        }
        fid.installFixtures();
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getCurrentTransaction();
        IsisTransaction.State transactionState = transaction.getState();
        if (transactionState.canCommit()) {
            this.commitTran();
            try {
                this.nextSession();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.beginTran();
        }
    }

    private IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }

    private PersistenceSession getPersistenceSession() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }

    public static class Builder<T extends Builder<T, S>, S extends IsisSystem> {
        protected AuthenticationRequest authenticationRequest = new AuthenticationRequestNameOnly("tester");
        protected IsisConfigurationDefault configuration = new IsisConfigurationDefault();
        protected AppManifest appManifestIfAny;
        protected Level level;

        public T with(IsisConfiguration configuration) {
            this.configuration = (IsisConfigurationDefault)configuration;
            return (T)this;
        }

        public T with(AuthenticationRequest authenticationRequest) {
            this.authenticationRequest = authenticationRequest;
            return (T)this;
        }

        public T with(AppManifest appManifest) {
            this.appManifestIfAny = appManifest;
            return (T)this;
        }

        public T withLoggingAt(Level level) {
            this.level = level;
            return (T)this;
        }

        public S build() {
            IsisSystem isisSystem = new IsisSystem(this.appManifestIfAny, (IsisConfiguration)this.configuration, this.authenticationRequest);
            return (S)this.configure(isisSystem);
        }

        protected <T extends IsisSystem> T configure(final T isisSystem) {
            if (this.level != null) {
                isisSystem.setLevel(this.level);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public synchronized void run() {
                    try {
                        isisSystem.closeSession();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (isisSystem.isisSessionFactory != null) {
                            isisSystem.isisSessionFactory.destroyServicesAndShutdown();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            return isisSystem;
        }
    }
}

