/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.headless;

import com.google.common.base.Strings;
import java.io.PrintStream;
import org.apache.isis.applib.Module;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.services.xactn.TransactionService3;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.runtime.headless.HeadlessAbstract;
import org.apache.isis.core.runtime.headless.IsisSystem;
import org.apache.isis.core.runtime.headless.IsisSystemBootstrapper;
import org.apache.isis.core.runtime.headless.logging.LogConfig;
import org.apache.isis.core.runtime.headless.logging.LogStream;
import org.apache.log4j.PropertyConfigurator;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class HeadlessWithBootstrappingAbstract
extends HeadlessAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(HeadlessWithBootstrappingAbstract.class);
    private final LogConfig logConfig;
    private static final ThreadLocal<Boolean> setupLogging = new ThreadLocal<Boolean>(){
        {
            this.set(false);
        }
    };
    private final IsisSystemBootstrapper isisSystemBootstrapper;
    private LocalDate timeBeforeTest;

    protected static PrintStream logPrintStream(Level level) {
        return LogStream.logPrintStream(LOG, level);
    }

    protected HeadlessWithBootstrappingAbstract(Module module) {
        this(new LogConfig(Level.INFO), module);
    }

    protected HeadlessWithBootstrappingAbstract(LogConfig logConfig, Module module) {
        boolean firstTime;
        this.logConfig = logConfig;
        boolean bl = firstTime = setupLogging.get() == false;
        if (firstTime) {
            PropertyConfigurator.configure((String)logConfig.getLoggingPropertyFile());
            setupLogging.set(true);
        }
        String integTestModuleFqcn = System.getProperty("isis.integTest.module");
        LOG.info("isis.integTest.module = {}", (Object)integTestModuleFqcn);
        String moduleFqcn = integTestModuleFqcn;
        if (moduleFqcn == null) {
            String headlessModuleFqcn = System.getProperty("isis.headless.module");
            LOG.info("isis.headless.module = {}", (Object)headlessModuleFqcn);
            moduleFqcn = headlessModuleFqcn;
        }
        Module moduleToUse = !Strings.isNullOrEmpty((String)moduleFqcn) ? (Module)InstanceUtil.createInstance((String)moduleFqcn, Module.class, (Object[])new Object[0]) : module;
        this.isisSystemBootstrapper = new IsisSystemBootstrapper(logConfig, moduleToUse);
    }

    protected void bootstrapAndSetupIfRequired() {
        System.setProperty("isis.headless", "true");
        System.setProperty("isis.integTest", "true");
        System.setProperty("isis.bddSpec", "true");
        this.isisSystemBootstrapper.bootstrapIfRequired();
        this.isisSystemBootstrapper.injectServicesInto(this);
        this.fixtureScripts.setFixtureTracing(this.logConfig.getFixtureTracing());
        this.beginTransaction();
        this.isisSystemBootstrapper.setupModuleRefData();
        this.timeBeforeTest = Clock.getTimeAsLocalDate();
    }

    private void beginTransaction() {
        IsisSystem isft = IsisSystem.get();
        isft.beginTran();
    }

    protected void tearDownAllModules() {
        boolean testHealthy;
        boolean bl = testHealthy = this.transactionService != null;
        if (!testHealthy) {
            return;
        }
        this.transactionService.nextTransaction(TransactionService3.Policy.ALWAYS);
        this.isisSystemBootstrapper.tearDownAllModules();
        this.setFixtureClockDate(this.timeBeforeTest);
    }

    protected void log(String message) {
        switch (this.logConfig.getTestLoggingLevel()) {
            case ERROR: {
                LOG.error(message);
                break;
            }
            case WARN: {
                LOG.warn(message);
                break;
            }
            case INFO: {
                LOG.info(message);
                break;
            }
            case DEBUG: {
                LOG.debug(message);
                break;
            }
            case TRACE: {
                LOG.trace(message);
            }
        }
    }
}

