/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.headless;

import javax.inject.Inject;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.applib.fixtures.TickingFixtureClock;
import org.apache.isis.applib.fixturescripts.BuilderScriptAbstract;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.fixturescripts.PersonaWithBuilderScript;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.metamodel.MetaModelService4;
import org.apache.isis.applib.services.registry.ServiceRegistry2;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.sessmgmt.SessionManagementService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.xactn.TransactionService3;
import org.joda.time.LocalDate;

public abstract class HeadlessAbstract {
    @Inject
    protected MetaModelService4 metaModelService4;
    @Inject
    protected FixtureScripts fixtureScripts;
    @Inject
    protected FactoryService factoryService;
    @Inject
    protected ServiceRegistry2 serviceRegistry;
    @Inject
    protected RepositoryService repositoryService;
    @Inject
    protected UserService userService;
    @Inject
    protected WrapperFactory wrapperFactory;
    @Inject
    protected TransactionService3 transactionService;
    @Inject
    protected SessionManagementService sessionManagementService;

    protected void runFixtureScript(FixtureScript ... fixtureScriptList) {
        this.fixtureScripts.runFixtureScript(fixtureScriptList);
    }

    protected <T, F extends BuilderScriptAbstract<T, F>> T runBuilderScript(F fixtureScript) {
        return (T)this.fixtureScripts.runBuilderScript(fixtureScript);
    }

    protected <P extends PersonaWithBuilderScript<T, F>, T, F extends BuilderScriptAbstract<T, F>> T runBuilderScript(P persona) {
        return this.runBuilderScript((P)persona.builder());
    }

    protected <T> T wrap(T obj) {
        return (T)this.wrapperFactory.wrap(obj);
    }

    protected <T> T mixin(Class<T> mixinClass, Object mixedIn) {
        return (T)this.factoryService.mixin(mixinClass, mixedIn);
    }

    protected void setFixtureClockDate(LocalDate date) {
        if (date == null) {
            return;
        }
        this.setFixtureClockDate(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth());
    }

    protected void setFixtureClockDate(int year, int month, int day) {
        Clock instance = Clock.getInstance();
        if (instance instanceof TickingFixtureClock) {
            TickingFixtureClock.reinstateExisting();
            this.getFixtureClock().setDate(year, month, day);
            TickingFixtureClock.replaceExisting();
        }
        if (instance instanceof FixtureClock) {
            this.getFixtureClock().setDate(year, month, day);
        }
    }

    private FixtureClock getFixtureClock() {
        return (FixtureClock)FixtureClock.getInstance();
    }

    protected <T> T unwrap(T obj) {
        return (T)this.wrapperFactory.unwrap(obj);
    }
}

