/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.fixtures;

import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.runtime.fixtures.FixturesInstallerAbstract;
import org.apache.isis.core.runtime.fixtures.FixturesInstallerDelegate;
import org.apache.isis.core.runtime.fixtures.domainservice.ObjectLoaderFixture;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixturesInstallerFromConfiguration
extends FixturesInstallerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(FixturesInstallerFromConfiguration.class);
    public static final String FIXTURES = "isis.fixtures";
    @Deprecated
    private static final String FIXTURES_PREFIX = "isis.fixtures.prefix";
    private static final String EXPLORATION_OBJECTS = "isis.exploration-objects";

    public FixturesInstallerFromConfiguration(IsisSessionFactory isisSessionFactory) {
        super(isisSessionFactory);
    }

    @Override
    protected void addFixturesTo(FixturesInstallerDelegate delegate) {
        FixtureConfig fixtureConfig = this.getFixtureConfig();
        try {
            boolean fixtureLoaded = false;
            for (String element : fixtureConfig.getFixtures()) {
                String fixtureFullyQualifiedName = fixtureConfig.getFixturePrefix() + element;
                LOG.info("  adding fixture {}", (Object)fixtureFullyQualifiedName);
                Object fixture = InstanceUtil.createInstance((String)fixtureFullyQualifiedName, (Object[])new Object[0]);
                fixtureLoaded = true;
                delegate.addFixture(fixture);
            }
            if (this.configuration.getBoolean(EXPLORATION_OBJECTS)) {
                delegate.addFixture(new ObjectLoaderFixture());
            }
            if (!fixtureLoaded) {
                LOG.debug("No fixtures loaded from configuration");
            }
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new IsisException((Throwable)e);
        }
    }

    private FixtureConfig getFixtureConfig() {
        FixtureConfig fixtureConfig = new FixtureConfig();
        fixtureConfig.setFixtures(this.configuration.getList(FIXTURES));
        fixtureConfig.setFixturePrefix(this.configuration.getString(FIXTURES_PREFIX));
        return fixtureConfig;
    }

    private static class FixtureConfig {
        private String[] fixtures;
        private String fixturePrefix;

        private FixtureConfig() {
        }

        String[] getFixtures() {
            return this.fixtures;
        }

        void setFixtures(String[] fixtures) {
            this.fixtures = fixtures;
        }

        void setFixtures(String fixturesStr) {
            if (fixturesStr != null) {
                this.setFixtures(new String[]{fixturesStr});
            } else {
                this.setFixtures(new String[0]);
            }
        }

        boolean hasFixtures() {
            return this.fixtures != null && this.fixtures.length != 0;
        }

        String getFixturePrefix() {
            return this.fixturePrefix;
        }

        void setFixturePrefix(String fixturePrefix) {
            String string = fixturePrefix = fixturePrefix == null ? "" : fixturePrefix.trim();
            if (fixturePrefix.length() > 0 && !fixturePrefix.endsWith(".")) {
                fixturePrefix = fixturePrefix + ".";
            }
            this.fixturePrefix = fixturePrefix;
        }
    }
}

