/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.fixturedomainservice;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.AbstractService;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.services.registry.ServiceRegistry2;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.Persistability;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.fixturedomainservice.ObjectFixtureFilePersistor;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFixtureService {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectFixtureService.class);
    private static final String DATA_FILEPATH = "isis.exploration-objects.file";
    private static final String DEFAULT_FILEPATH = "fixture-data";
    private ObjectFixtureFilePersistor persistor;
    private Set<Object> objects = Sets.newHashSet();
    @Inject
    IsisSessionFactory isisSessionFactory;
    @Inject
    IsisConfiguration configuration;
    @Inject
    ServiceRegistry2 serviceRegistry;

    @PostConstruct
    public void init() {
        this.persistor = new ObjectFixtureFilePersistor();
        this.serviceRegistry.injectServicesInto((Object)this.persistor);
    }

    public String title() {
        return "Fixture Objects";
    }

    public String getId() {
        return "fixtures";
    }

    public String iconName() {
        return "Fixture";
    }

    @Action(restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(describedAs="Add this object to the set of saved objects")
    @MemberOrder(sequence="1")
    public void save(Object object) {
        ObjectAdapter adapter = this.getPersistenceSession().adapterFor(object);
        if (adapter.getSpecification().persistability() != Persistability.TRANSIENT) {
            LOG.info("Saving object for fixture: {}", (Object)adapter);
            this.addObjectAndAssociates(adapter);
            this.saveAll();
        }
    }

    private void addObjectAndAssociates(ObjectAdapter adapter) {
        if (this.objects.contains(adapter.getObject())) {
            return;
        }
        this.objects.add(adapter.getObject());
        ObjectSpecification adapterSpec = adapter.getSpecification();
        List associations = adapterSpec.getAssociations(Contributed.EXCLUDED);
        for (ObjectAssociation association : associations) {
            if (association.isNotPersisted()) continue;
            ObjectAdapter associatedObject = association.get(adapter, InteractionInitiatedBy.FRAMEWORK);
            boolean isEmpty = association.isEmpty(adapter, InteractionInitiatedBy.FRAMEWORK);
            if (isEmpty) continue;
            if (association.isOneToManyAssociation()) {
                CollectionFacet facet = (CollectionFacet)associatedObject.getSpecification().getFacet(CollectionFacet.class);
                for (ObjectAdapter element : facet.iterable(associatedObject)) {
                    this.addObjectAndAssociates(element);
                }
                continue;
            }
            if (!association.isOneToOneAssociation() || association.getSpecification().isParseable()) continue;
            this.addObjectAndAssociates(associatedObject);
        }
    }

    public String validateSave(Object object) {
        if (object == this || object instanceof AbstractService) {
            return "Can't add/remove a service";
        }
        return this.objects.contains(object) ? "This object has already been saved" : null;
    }

    @Action(restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(describedAs="Remove this object from the set of saved objects")
    @MemberOrder(sequence="2")
    public void remove(Object object) {
        this.objects.remove(object);
        this.saveAll();
    }

    public String validateRemove(Object object) {
        if (object == this || object instanceof AbstractService) {
            return "Can't add/remove a service";
        }
        return this.objects.contains(object) ? null : "Can't remove an object that has not been saved";
    }

    @Action(restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(describedAs="Retrieved all the saved objects")
    @MemberOrder(sequence="4")
    public Set<Object> allSavedObjects() {
        return this.objects;
    }

    @Action(restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(describedAs="Save the current state of the saved objects")
    @MemberOrder(sequence="3")
    public void saveAll() {
        OutputStreamWriter out = null;
        try {
            File file = this.file(true);
            out = new FileWriter(file);
            this.persistor.save(this.objects, out);
        }
        catch (IOException e) {
            throw new IsisException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new IsisException((Throwable)e);
                }
            }
        }
    }

    @Programmatic
    public void loadFile() {
        InputStreamReader reader = null;
        try {
            File file = this.file(false);
            reader = new FileReader(file);
            this.objects = this.persistor.loadData(reader);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            throw new IsisException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new IsisException((Throwable)e);
                }
            }
        }
    }

    private File file(boolean createFileIfDoesntExist) throws IOException {
        String fixturePath = this.configuration.getString(DATA_FILEPATH, DEFAULT_FILEPATH);
        File file = new File(fixturePath);
        File directory = file.getParentFile();
        this.mkdirIfRequired(directory);
        if (!file.exists() && createFileIfDoesntExist) {
            this.createFile(file);
        }
        return file;
    }

    private void mkdirIfRequired(File directory) {
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
    }

    private void createFile(File file) throws IOException {
        file.createNewFile();
    }

    protected PersistenceSession getPersistenceSession() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }
}

