/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.fixturedomainservice;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.fixturedomainservice.FixtureException;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;

class LoadedObjects {
    private final Map<String, ObjectAdapter> idMap = Maps.newHashMap();
    private final Set<Object> objects;
    private final SpecificationLoader specificationLoader;
    private final PersistenceSession persistenceSession;

    public LoadedObjects(Set<Object> objects, SpecificationLoader specificationLoader, PersistenceSession persistenceSession) {
        this.objects = objects;
        this.specificationLoader = specificationLoader;
        this.persistenceSession = persistenceSession;
    }

    public ObjectAdapter get(String data) {
        int pos = data.indexOf(35);
        if (pos == -1) {
            throw new FixtureException("load failed - trying to read non-reference data as a reference: " + data);
        }
        String id = data.substring(pos + 1);
        ObjectAdapter object = this.idMap.get(id);
        if (object == null) {
            String className = data.substring(0, pos);
            ObjectSpecification specification = this.specificationLoader.loadSpecification(className);
            object = this.persistenceSession.createTransientInstance(specification);
            this.idMap.put(id, object);
            this.objects.add(object.getObject());
        }
        return object;
    }
}

