/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils.jaxbadapters;

import com.sun.org.apache.xerces.internal.jaxp.datatype.XMLGregorianCalendarImpl;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.LocalTime;

public final class JodaLocalTimeXMLGregorianCalendarAdapter {
    private JodaLocalTimeXMLGregorianCalendarAdapter() {
    }

    public static LocalTime parse(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return null;
        }
        int hour = xgc.getHour();
        int minute = xgc.getMinute();
        int second = xgc.getSecond();
        int millisecond = xgc.getMillisecond();
        return new LocalTime(hour, minute, second, millisecond);
    }

    public static XMLGregorianCalendar print(LocalTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        XMLGregorianCalendarImpl xgc = new XMLGregorianCalendarImpl();
        xgc.setHour(dateTime.getHourOfDay());
        xgc.setMinute(dateTime.getMinuteOfHour());
        xgc.setSecond(dateTime.getSecondOfMinute());
        xgc.setMillisecond(dateTime.getMillisOfSecond());
        return xgc;
    }

    public static class ForJaxb
    extends XmlAdapter<XMLGregorianCalendar, LocalTime> {
        public LocalTime unmarshal(XMLGregorianCalendar localTimeStr) throws Exception {
            return JodaLocalTimeXMLGregorianCalendarAdapter.parse(localTimeStr);
        }

        public XMLGregorianCalendar marshal(LocalTime LocalTime2) throws Exception {
            return JodaLocalTimeXMLGregorianCalendarAdapter.print(LocalTime2);
        }
    }
}

