/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils.jaxbadapters;

import com.sun.org.apache.xerces.internal.jaxp.datatype.XMLGregorianCalendarImpl;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.LocalDateTime;

public final class JodaLocalDateTimeXMLGregorianCalendarAdapter {
    private JodaLocalDateTimeXMLGregorianCalendarAdapter() {
    }

    public static LocalDateTime parse(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return null;
        }
        int year = xgc.getYear();
        int month = xgc.getMonth();
        int day = xgc.getDay();
        int hour = xgc.getHour();
        int minute = xgc.getMinute();
        int second = xgc.getSecond();
        int millisecond = xgc.getMillisecond();
        return new LocalDateTime(year, month, day, hour, minute, second, millisecond);
    }

    public static XMLGregorianCalendar print(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        XMLGregorianCalendarImpl xgc = new XMLGregorianCalendarImpl();
        xgc.setYear(dateTime.getYear());
        xgc.setMonth(dateTime.getMonthOfYear());
        xgc.setDay(dateTime.getDayOfMonth());
        xgc.setHour(dateTime.getHourOfDay());
        xgc.setMinute(dateTime.getMinuteOfHour());
        xgc.setSecond(dateTime.getSecondOfMinute());
        xgc.setMillisecond(dateTime.getMillisOfSecond());
        return xgc;
    }

    public static class ForJaxb
    extends XmlAdapter<XMLGregorianCalendar, LocalDateTime> {
        public LocalDateTime unmarshal(XMLGregorianCalendar localDateTimeStr) throws Exception {
            return JodaLocalDateTimeXMLGregorianCalendarAdapter.parse(localDateTimeStr);
        }

        public XMLGregorianCalendar marshal(LocalDateTime LocalDateTime2) throws Exception {
            return JodaLocalDateTimeXMLGregorianCalendarAdapter.print(LocalDateTime2);
        }
    }
}

