/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils.jaxbadapters;

import com.google.common.base.Strings;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class JodaDateTimeStringAdapter {
    private static DateTimeFormatter formatter = ISODateTimeFormat.dateTime();

    private JodaDateTimeStringAdapter() {
    }

    public static DateTime parse(String dateTimeStr) {
        return !Strings.isNullOrEmpty((String)dateTimeStr) ? formatter.parseDateTime(dateTimeStr) : null;
    }

    public static String print(DateTime date) {
        if (date == null) {
            return null;
        }
        return formatter.print((ReadableInstant)date);
    }

    public static class ForJaxb
    extends XmlAdapter<String, DateTime> {
        public DateTime unmarshal(String dateTimeStr) throws Exception {
            return JodaDateTimeStringAdapter.parse(dateTimeStr);
        }

        public String marshal(DateTime dateTime) throws Exception {
            return JodaDateTimeStringAdapter.print(dateTime);
        }
    }
}

