/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils.jaxbadapters;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.bookmark.BookmarkService2;
import org.apache.isis.schema.common.v1.OidDto;
import org.apache.isis.schema.common.v1.OidsDto;

public class PersistentEntitiesAdapter
extends XmlAdapter<OidsDto, List<Object>> {
    @Inject
    BookmarkService2 bookmarkService;

    public List<Object> unmarshal(OidsDto oidsDto) throws Exception {
        ArrayList domainObjects = Lists.newArrayList();
        for (OidDto oidDto : oidsDto.getOid()) {
            Bookmark bookmark = Bookmark.from(oidDto);
            Object domainObject = this.bookmarkService.lookup(bookmark, BookmarkService2.FieldResetPolicy.DONT_RESET);
            domainObjects.add(domainObject);
        }
        return domainObjects;
    }

    public OidsDto marshal(List<Object> domainObjects) throws Exception {
        if (domainObjects == null) {
            return null;
        }
        OidsDto oidsDto = new OidsDto();
        for (Object domainObject : domainObjects) {
            Bookmark bookmark = this.getBookmarkService().bookmarkFor(domainObject);
            oidsDto.getOid().add(bookmark.toOidDto());
        }
        return oidsDto;
    }

    private static String coalesce(String first, String second) {
        return first != null ? first : second;
    }

    protected BookmarkService getBookmarkService() {
        return this.bookmarkService;
    }
}

