/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.utils;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.isis.applib.util.JaxbUtil;
import org.apache.isis.schema.common.v1.DifferenceDto;
import org.apache.isis.schema.common.v1.PeriodDto;
import org.apache.isis.schema.ixn.v1.MemberExecutionDto;
import org.apache.isis.schema.ixn.v1.MetricsDto;
import org.apache.isis.schema.ixn.v1.ObjectCountsDto;

public final class MemberExecutionDtoUtils {
    public static <T extends MemberExecutionDto> T clone(T dto) {
        Class<?> aClass = dto.getClass();
        return MemberExecutionDtoUtils.clone(dto, aClass);
    }

    private static <T> T clone(T dto, Class<T> dtoClass) {
        try {
            JAXBContext jaxbContext = MemberExecutionDtoUtils.jaxbContextFor(dtoClass);
            Marshaller marshaller = jaxbContext.createMarshaller();
            QName name = new QName("", dtoClass.getSimpleName());
            JAXBElement jaxbElement = new JAXBElement(name, dtoClass, null, dto);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)jaxbElement, (Writer)stringWriter);
            StringReader reader = new StringReader(stringWriter.toString());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement root = unmarshaller.unmarshal((Source)new StreamSource(reader), dtoClass);
            return (T)root.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> JAXBContext jaxbContextFor(Class<T> dtoClass) {
        return JaxbUtil.jaxbContextFor(dtoClass);
    }

    public static MetricsDto metricsFor(MemberExecutionDto executionDto) {
        MetricsDto metrics = executionDto.getMetrics();
        if (metrics == null) {
            metrics = new MetricsDto();
            executionDto.setMetrics(metrics);
        }
        return metrics;
    }

    public static PeriodDto timingsFor(MetricsDto metricsDto) {
        PeriodDto timings = metricsDto.getTimings();
        if (timings == null) {
            timings = new PeriodDto();
            metricsDto.setTimings(timings);
        }
        return timings;
    }

    public static ObjectCountsDto objectCountsFor(MetricsDto metricsDto) {
        ObjectCountsDto objectCounts = metricsDto.getObjectCounts();
        if (objectCounts == null) {
            objectCounts = new ObjectCountsDto();
            metricsDto.setObjectCounts(objectCounts);
        }
        return objectCounts;
    }

    public static DifferenceDto numberObjectsLoadedFor(ObjectCountsDto objectCountsDto) {
        DifferenceDto differenceDto = objectCountsDto.getLoaded();
        if (differenceDto == null) {
            differenceDto = new DifferenceDto();
            objectCountsDto.setLoaded(differenceDto);
        }
        return differenceDto;
    }

    public static DifferenceDto numberObjectsDirtiedFor(ObjectCountsDto objectCountsDto) {
        DifferenceDto differenceDto = objectCountsDto.getDirtied();
        if (differenceDto == null) {
            differenceDto = new DifferenceDto();
            objectCountsDto.setDirtied(differenceDto);
        }
        return differenceDto;
    }
}

