/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.schema.services.jaxb;

import java.util.Map;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.domain.DomainObjectList;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.metamodel.MetaModelService5;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.schema.utils.jaxbadapters.PersistentEntitiesAdapter;
import org.apache.isis.schema.utils.jaxbadapters.PersistentEntityAdapter;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class JaxbServiceDefault
extends JaxbService.Simple {
    @Inject
    ServiceRegistry serviceRegistry;
    @Inject
    MetaModelService5 metaModelService5;

    @Override
    public Object fromXml(JAXBContext jaxbContext, String xml, Map<String, Object> unmarshallerProperties) {
        try {
            Object pojo = this.internalFromXml(jaxbContext, xml, unmarshallerProperties);
            if (pojo instanceof DomainObjectList) {
                DomainObjectList list = (DomainObjectList)pojo;
                JAXBContext jaxbContextForList = this.jaxbContextFor(list);
                return this.internalFromXml(jaxbContextForList, xml, unmarshallerProperties);
            }
            return pojo;
        }
        catch (JAXBException ex) {
            throw new NonRecoverableException("Error unmarshalling XML", ex);
        }
    }

    @Override
    protected JAXBContext jaxbContextFor(Object domainObject) {
        Class<?> domainClass = domainObject.getClass();
        if (domainObject instanceof DomainObjectList) {
            DomainObjectList list = (DomainObjectList)domainObject;
            try {
                String elementObjectType = list.getElementObjectType();
                Class<?> elementType = this.metaModelService5.fromObjectType(elementObjectType);
                if (elementType.getAnnotation(XmlJavaTypeAdapter.class) == null) {
                    return JAXBContext.newInstance((Class[])new Class[]{domainClass, elementType});
                }
                return JAXBContext.newInstance((Class[])new Class[]{domainClass});
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return super.jaxbContextFor(domainObject);
    }

    @Override
    protected void configure(Unmarshaller unmarshaller) {
        unmarshaller.setAdapter(PersistentEntityAdapter.class, (XmlAdapter)this.serviceRegistry.injectServicesInto(new PersistentEntityAdapter()));
        unmarshaller.setAdapter(PersistentEntitiesAdapter.class, (XmlAdapter)this.serviceRegistry.injectServicesInto(new PersistentEntitiesAdapter()));
    }

    @Override
    protected void configure(Marshaller marshaller) {
        marshaller.setAdapter(PersistentEntityAdapter.class, (XmlAdapter)this.serviceRegistry.injectServicesInto(new PersistentEntityAdapter()));
        marshaller.setAdapter(PersistentEntitiesAdapter.class, (XmlAdapter)this.serviceRegistry.injectServicesInto(new PersistentEntitiesAdapter()));
    }
}

