/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.value;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.isis.applib.value.NamedWithMimeType;

public final class Blob
implements NamedWithMimeType,
Serializable {
    private static final long serialVersionUID = 5659679806709601263L;
    private final MimeType mimeType;
    private final byte[] bytes;
    private final String name;

    public Blob(String name, String primaryType, String subtype, byte[] bytes) {
        this(name, Blob.newMimeType(primaryType, subtype), bytes);
    }

    public Blob(String name, String mimeTypeBase, byte[] bytes) {
        this(name, Blob.newMimeType(mimeTypeBase), bytes);
    }

    public Blob(String name, MimeType mimeType, byte[] bytes) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (mimeType == null) {
            throw new IllegalArgumentException("MimeType cannot be null");
        }
        if (name.contains(":")) {
            throw new IllegalArgumentException("Name cannot contain ':'");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Bytes cannot be null");
        }
        this.name = name;
        this.mimeType = mimeType;
        this.bytes = bytes;
    }

    private static MimeType newMimeType(String primaryType, String subtype) {
        try {
            return new MimeType(primaryType, subtype);
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static MimeType newMimeType(String baseType) {
        try {
            return new MimeType(baseType);
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MimeType getMimeType() {
        return this.mimeType;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void writeBytesTo(OutputStream os) throws IOException {
        ByteSource.wrap((byte[])this.bytes).copyTo(os);
    }

    public String toString() {
        return this.getName() + " [" + this.getMimeType().getBaseType() + "]: " + this.getBytes().length + " bytes";
    }
}

