/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.util;

import com.google.common.collect.MapMaker;
import com.google.common.io.Resources;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JaxbUtil {
    private static Map<Class<?>, JAXBContext> jaxbContextByClass = new MapMaker().concurrencyLevel(10).makeMap();

    private JaxbUtil() {
    }

    public static <T> T fromXml(Reader reader, Class<T> dtoClass) {
        Unmarshaller un = null;
        try {
            un = JaxbUtil.jaxbContextFor(dtoClass).createUnmarshaller();
            return (T)un.unmarshal(reader);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromXml(Class<?> contextClass, String resourceName, Charset charset, Class<T> dtoClass) throws IOException {
        URL url = Resources.getResource(contextClass, (String)resourceName);
        String s = Resources.toString((URL)url, (Charset)charset);
        return JaxbUtil.fromXml(new StringReader(s), dtoClass);
    }

    public static <T> String toXml(T dto) {
        CharArrayWriter caw = new CharArrayWriter();
        JaxbUtil.toXml(dto, caw);
        return caw.toString();
    }

    public static <T> void toXml(T dto, Writer writer) {
        Marshaller m = null;
        try {
            Class<?> aClass = dto.getClass();
            m = JaxbUtil.jaxbContextFor(aClass).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(dto, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> JAXBContext jaxbContextFor(Class<T> dtoClass) {
        JAXBContext jaxbContext = jaxbContextByClass.get(dtoClass);
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{dtoClass});
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            jaxbContextByClass.put(dtoClass, jaxbContext);
        }
        return jaxbContext;
    }
}

