/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.urlencoding;

import com.google.common.io.BaseEncoding;
import java.nio.charset.Charset;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.urlencoding.UrlEncodingService;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class UrlEncodingServiceUsingBaseEncoding
implements UrlEncodingService {
    private final BaseEncoding baseEncoding;
    private final Charset charset;

    public UrlEncodingServiceUsingBaseEncoding(BaseEncoding baseEncoding, Charset charset) {
        this.baseEncoding = baseEncoding;
        this.charset = charset;
    }

    public UrlEncodingServiceUsingBaseEncoding() {
        this(BaseEncoding.base64Url(), Charset.forName("UTF-8"));
    }

    @Override
    @Programmatic
    public String encode(String str) {
        byte[] bytes = str.getBytes(this.charset);
        return this.baseEncoding.encode(bytes);
    }

    @Override
    @Programmatic
    public String decode(String str) {
        byte[] bytes = this.baseEncoding.decode((CharSequence)str);
        return new String(bytes, Charset.forName("UTF-8"));
    }
}

