/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.queryresultscache;

import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.apache.isis.applib.AbstractSubscriber;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.events.system.FixturesInstalledEvent;
import org.apache.isis.applib.events.system.FixturesInstallingEvent;
import org.apache.isis.applib.services.WithTransactionScope;
import org.axonframework.eventhandling.annotation.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
@RequestScoped
public class QueryResultsCache
implements WithTransactionScope {
    private static final Logger LOG = LoggerFactory.getLogger(QueryResultsCache.class);
    private final Map<Key, Value<?>> cache = Maps.newHashMap();
    @Inject
    protected Control control;

    @Programmatic
    public <T> T execute(Callable<T> callable, Class<?> callingClass, String methodName, Object ... keys) {
        if (this.control.isFixturesInstalling()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Key cacheKey = new Key(callingClass, methodName, keys);
        return this.executeWithCaching(callable, cacheKey);
    }

    @Programmatic
    public <T> T execute(Callable<T> callable, Key cacheKey) {
        if (this.control.isFixturesInstalling()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.executeWithCaching(callable, cacheKey);
    }

    protected <T> T executeWithCaching(Callable<T> callable, Key cacheKey) {
        try {
            Value<?> cacheValue = this.cache.get(cacheKey);
            QueryResultsCache.logHitOrMiss(cacheKey, cacheValue);
            if (cacheValue != null) {
                return (T)cacheValue.getResult();
            }
            T result = callable.call();
            this.put(cacheKey, result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Programmatic
    public <T> Value<T> get(Class<?> callingClass, String methodName, Object ... keys) {
        return this.get(new Key(callingClass, methodName, keys));
    }

    @Programmatic
    public <T> Value<T> get(Key cacheKey) {
        Value<?> value = this.cache.get(cacheKey);
        QueryResultsCache.logHitOrMiss(cacheKey, value);
        return value;
    }

    @Programmatic
    public <T> void put(Key cacheKey, T result) {
        LOG.debug("PUT: {}", (Object)cacheKey);
        this.cache.put(cacheKey, new Value<T>(result));
    }

    private static void logHitOrMiss(Key cacheKey, Value<?> cacheValue) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("{}: {}", (Object)(cacheValue != null ? "HIT" : "MISS"), (Object)cacheKey.toString());
    }

    @Override
    @Programmatic
    public void resetForNextTransaction() {
        this.cache.clear();
    }

    @DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
    public static class Control
    extends AbstractSubscriber {
        private boolean fixturesInstalling;

        @Programmatic
        @Subscribe
        @EventHandler
        public void on(FixturesInstallingEvent ev) {
            this.fixturesInstalling = true;
        }

        @Programmatic
        @Subscribe
        @EventHandler
        public void on(FixturesInstalledEvent ev) {
            this.fixturesInstalling = false;
        }

        @Programmatic
        public boolean isFixturesInstalling() {
            return this.fixturesInstalling;
        }
    }

    public static class Value<T> {
        private T result;

        public Value(T result) {
            this.result = result;
        }

        public T getResult() {
            return this.result;
        }
    }

    public static class Key {
        private final Class<?> callingClass;
        private final String methodName;
        private final Object[] keys;

        public Key(Class<?> callingClass, String methodName, Object ... keys) {
            this.callingClass = callingClass;
            this.methodName = methodName;
            this.keys = keys;
        }

        public Class<?> getCallingClass() {
            return this.callingClass;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Object[] getKeys() {
            return this.keys;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.callingClass == null ? other.callingClass != null : !this.callingClass.equals(other.callingClass)) {
                return false;
            }
            if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
                return false;
            }
            return Arrays.equals(this.keys, other.keys);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.callingClass == null ? 0 : this.callingClass.hashCode());
            result = 31 * result + Arrays.hashCode(this.keys);
            result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
            return result;
        }

        public String toString() {
            return this.callingClass.getName() + "#" + this.methodName + Arrays.toString(this.keys);
        }
    }
}

