/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.publish;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.publish.PublishedObjects;
import org.apache.isis.applib.services.publish.PublisherService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.schema.chg.v1.ChangesDto;
import org.apache.isis.schema.ixn.v1.InteractionDto;
import org.apache.isis.schema.utils.ChangesDtoUtils;
import org.apache.isis.schema.utils.InteractionDtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class PublisherServiceLogging
implements PublisherService {
    private static final Logger LOG = LoggerFactory.getLogger(PublisherServiceLogging.class);
    @Inject
    private CommandContext commandContext;
    @Inject
    private UserService userService;

    @PostConstruct
    public void init() {
    }

    @Override
    public void publish(Interaction.Execution<?, ?> execution) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        InteractionDto interactionDto = InteractionDtoUtils.newInteractionDto(execution, InteractionDtoUtils.Strategy.DEEP);
        LOG.debug(InteractionDtoUtils.toXml(interactionDto));
    }

    @Override
    public void publish(PublishedObjects publishedObjects) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        ChangesDto changesDto = publishedObjects.getDto();
        LOG.debug(ChangesDtoUtils.toXml(changesDto));
    }
}

