/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.inject.Inject;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.metamodel.DomainMember;
import org.apache.isis.applib.services.metamodel.MetaModelService6;
import org.apache.isis.applib.services.metamodel.Util;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.schema.metamodel.v1.MetamodelDto;

@DomainService(nature=NatureOfService.VIEW_MENU_ONLY, objectType="isisApplib.MetaModelServicesMenu")
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY, menuOrder="500.500")
public class MetaModelServicesMenu {
    private final MimeType mimeTypeTextCsv;
    private final MimeType mimeTypeTextXml;
    @Inject
    MetaModelService6 metaModelService;
    @Inject
    JaxbService jaxbService;

    public MetaModelServicesMenu() {
        try {
            this.mimeTypeTextCsv = new MimeType("text", "csv");
            this.mimeTypeTextXml = new MimeType("application", "xml");
        }
        catch (MimeTypeParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Action(domainEvent=DownloadMetaModelEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Meta Model (CSV)")
    @MemberOrder(sequence="500.500.1")
    public Clob downloadMetaModel(@ParameterLayout(named=".csv file name") String csvFileName) {
        List<DomainMember> rows = this.metaModelService.export();
        List<String> list = MetaModelServicesMenu.asList(rows);
        StringBuilder buf = MetaModelServicesMenu.asBuf(list);
        return new Clob(Util.withSuffix(csvFileName, "csv"), this.mimeTypeTextCsv, buf.toString().toCharArray());
    }

    public String default0DownloadMetaModel() {
        return "metamodel.csv";
    }

    @Action(domainEvent=DownloadMetaModelXmlEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Meta Model (XML)")
    @MemberOrder(sequence="500.500.2")
    public Clob downloadMetaModelXml(@ParameterLayout(named="Packages") List<String> packages, @ParameterLayout(named=".xml file name") String xmlFileName) {
        MetaModelService6.Config config = new MetaModelService6.Config().withIgnoreNoop().withIgnoreAbstractClasses().withIgnoreInterfaces().withIgnoreBuiltInValueTypes();
        for (String pkg : packages) {
            config = config.withPackagePrefix(pkg);
        }
        MetamodelDto metamodelDto = this.metaModelService.exportMetaModel(config);
        String asXml = this.jaxbService.toXml(metamodelDto);
        return new Clob(Util.withSuffix(xmlFileName, "xml"), this.mimeTypeTextXml, (CharSequence)asXml);
    }

    public String validateDownloadMetaModelXml(List<String> packagePrefixes, String xmlFileName) {
        if (packagePrefixes == null || packagePrefixes.isEmpty()) {
            return "At least one package must be selected";
        }
        return null;
    }

    public List<String> choices0DownloadMetaModelXml() {
        List<DomainMember> export = this.metaModelService.export();
        TreeSet packages = Sets.newTreeSet();
        for (DomainMember domainMember : export) {
            String packageName = domainMember.getPackageName();
            List split = Splitter.on((String)".").splitToList((CharSequence)packageName);
            StringBuilder buf = new StringBuilder();
            for (String part : split) {
                if (buf.length() > 0) {
                    buf.append(".");
                }
                buf.append(part);
                packages.add(buf.toString());
            }
        }
        return Lists.newArrayList((Iterable)packages);
    }

    public String default1DownloadMetaModelXml() {
        return "metamodel.xml";
    }

    private static StringBuilder asBuf(List<String> list) {
        StringBuilder buf = new StringBuilder();
        for (String row : list) {
            buf.append(row).append("\n");
        }
        return buf;
    }

    private static List<String> asList(List<DomainMember> rows) {
        ArrayList list = Lists.newArrayList();
        list.add(MetaModelServicesMenu.header());
        for (DomainMember row : rows) {
            list.add(MetaModelServicesMenu.asTextCsv(row));
        }
        return list;
    }

    private static String header() {
        return "classType,packageName,className,memberType,memberName,numParams,contributed?,contributedBy,mixedIn?,mixin,hidden,disabled,choices,autoComplete,default,validate";
    }

    private static String asTextCsv(DomainMember row) {
        return Joiner.on((String)",").join((Object)row.getClassType(), (Object)row.getPackageName(), new Object[]{row.getClassName(), row.getType(), row.getMemberName(), row.getNumParams(), row.isContributed() ? "Y" : "", row.getContributedBy(), row.isMixedIn() ? "Y" : "", row.getMixin(), row.getHidden(), row.getDisabled(), row.getChoices(), row.getAutoComplete(), row.getDefault(), row.getValidate()});
    }

    public static class DownloadMetaModelXmlEvent
    extends ActionDomainEvent {
    }

    public static class DownloadMetaModelEvent
    extends ActionDomainEvent {
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<MetaModelServicesMenu> {
    }
}

