/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.metamodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.metamodel.MetaModelService5;
import org.apache.isis.schema.metamodel.v1.MetamodelDto;

public interface MetaModelService6
extends MetaModelService5 {
    @Programmatic
    public MetamodelDto exportMetaModel(Config var1);

    public static class Config {
        private static final int IGNORE_NOOP_FACETS = 1;
        private static final int IGNORE_INTERFACES = 2;
        private static final int IGNORE_ABSTRACT_CLASSES = 4;
        private static final int IGNORE_BUILT_IN_VALUE_TYPES = 8;
        private static final int IGNORE_MIXINS = 16;
        private final int mask;
        private final List<String> packagePrefixes;

        public Config() {
            this(0, Collections.emptyList());
        }

        private Config(int mask, List<String> packagePrefixes) {
            this.mask = mask;
            this.packagePrefixes = Collections.unmodifiableList(packagePrefixes);
        }

        private Config(int mask) {
            this(mask, null);
        }

        public Config withIgnoreNoop() {
            return this.newConfigWith(1);
        }

        public Config withIgnoreInterfaces() {
            return this.newConfigWith(2);
        }

        public Config withIgnoreAbstractClasses() {
            return this.newConfigWith(4);
        }

        public Config withIgnoreBuiltInValueTypes() {
            return this.newConfigWith(8);
        }

        public Config withIgnoreMixins() {
            return this.newConfigWith(16);
        }

        private Config newConfigWith(int x) {
            return new Config(this.mask | x, this.packagePrefixes);
        }

        public Config withPackagePrefix(String packagePrefix) {
            ArrayList prefixes = Lists.newArrayList(this.packagePrefixes);
            prefixes.add(packagePrefix);
            return new Config(this.mask, prefixes);
        }

        public boolean isIgnoreNoop() {
            return this.hasFlag(1);
        }

        public boolean isIgnoreInterfaces() {
            return this.hasFlag(2);
        }

        public boolean isIgnoreAbstractClasses() {
            return this.hasFlag(4);
        }

        public boolean isIgnoreBuiltInValueTypes() {
            return this.hasFlag(8);
        }

        public boolean isIgnoreMixins() {
            return this.hasFlag(16);
        }

        public List<String> getPackagePrefixes() {
            return this.packagePrefixes;
        }

        private boolean hasFlag(int x) {
            return (this.mask & x) == x;
        }
    }
}

