/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.layout;

import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.inject.Inject;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.ParameterLayout;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.services.layout.LayoutService;
import org.apache.isis.applib.services.layout.LayoutService2;
import org.apache.isis.applib.services.layout.Util;
import org.apache.isis.applib.services.menu.MenuBarsService;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;

@DomainService(nature=NatureOfService.VIEW_MENU_ONLY, objectType="isisApplib.LayoutServiceMenu")
@DomainServiceLayout(named="Prototyping", menuBar=DomainServiceLayout.MenuBar.SECONDARY, menuOrder="500.400")
public class LayoutServiceMenu {
    private final MimeType mimeTypeApplicationZip;
    @Inject
    LayoutService2 layoutService;

    public LayoutServiceMenu() {
        try {
            this.mimeTypeApplicationZip = new MimeType("application", "zip");
        }
        catch (MimeTypeParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Action(domainEvent=DownloadLayoutsDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Object Layouts (ZIP)")
    @MemberOrder(sequence="500.400.1")
    public Blob downloadLayouts(LayoutService.Style style) {
        String fileName = "layouts." + style.name().toLowerCase() + ".zip";
        byte[] zipBytes = this.layoutService.toZip(style);
        return new Blob(fileName, this.mimeTypeApplicationZip, zipBytes);
    }

    public LayoutService.Style default0DownloadLayouts() {
        return LayoutService.Style.NORMALIZED;
    }

    @Action(domainEvent=DownloadMenuBarsLayoutDomainEvent.class, semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download Menu Bars Layout (XML)")
    @MemberOrder(sequence="500.400.2")
    public Clob downloadMenuBarsLayout(@ParameterLayout(named="File name") String fileName, MenuBarsService.Type type) {
        String xml = this.layoutService.toMenuBarsXml(type);
        return new Clob(Util.withSuffix(fileName, ".xml"), "text/xml", (CharSequence)xml);
    }

    public String default0DownloadMenuBarsLayout() {
        return "menubars.layout.xml";
    }

    public MenuBarsService.Type default1DownloadMenuBarsLayout() {
        return MenuBarsService.Type.DEFAULT;
    }

    public static class DownloadMenuBarsLayoutDomainEvent
    extends ActionDomainEvent {
    }

    public static class DownloadLayoutsDomainEvent
    extends ActionDomainEvent {
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<LayoutServiceMenu> {
    }
}

