/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.jaxb;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import org.apache.isis.applib.ApplicationException;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.jaxb.CatalogingSchemaOutputResolver;
import org.apache.isis.applib.util.JaxbUtil;

public interface JaxbService {
    @Programmatic
    public Object fromXml(JAXBContext var1, String var2);

    @Programmatic
    public Object fromXml(JAXBContext var1, String var2, Map<String, Object> var3);

    @Programmatic
    public <T> T fromXml(Class<T> var1, String var2);

    @Programmatic
    public <T> T fromXml(Class<T> var1, String var2, Map<String, Object> var3);

    @Programmatic
    public String toXml(Object var1);

    @Programmatic
    public String toXml(Object var1, Map<String, Object> var2);

    @Programmatic
    public Map<String, String> toXsd(Object var1, IsisSchemas var2);

    public static class Simple
    implements JaxbService {
        @Override
        public Object fromXml(JAXBContext jaxbContext, String xml) {
            return this.fromXml(jaxbContext, xml, (Map<String, Object>)Maps.newHashMap());
        }

        @Override
        public Object fromXml(JAXBContext jaxbContext, String xml, Map<String, Object> unmarshallerProperties) {
            try {
                return this.internalFromXml(jaxbContext, xml, unmarshallerProperties);
            }
            catch (JAXBException ex) {
                throw new NonRecoverableException("Error unmarshalling XML", ex);
            }
        }

        protected Object internalFromXml(JAXBContext jaxbContext, String xml, Map<String, Object> unmarshallerProperties) throws JAXBException {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            for (Map.Entry<String, Object> entry : unmarshallerProperties.entrySet()) {
                unmarshaller.setProperty(entry.getKey(), entry.getValue());
            }
            this.configure(unmarshaller);
            return unmarshaller.unmarshal((Reader)new StringReader(xml));
        }

        @Override
        public <T> T fromXml(Class<T> domainClass, String xml) {
            return this.fromXml(domainClass, xml, (Map<String, Object>)Maps.newHashMap());
        }

        @Override
        public <T> T fromXml(Class<T> domainClass, String xml, Map<String, Object> unmarshallerProperties) {
            JAXBContext context = Simple.jaxbContextFor(domainClass);
            return (T)this.fromXml(context, xml, unmarshallerProperties);
        }

        private static <T> JAXBContext jaxbContextFor(Class<T> clazz) {
            try {
                return JaxbUtil.jaxbContextFor(clazz);
            }
            catch (RuntimeException e) {
                throw new NonRecoverableException("Error obtaining JAXBContext for class '" + clazz + "'", e.getCause());
            }
        }

        @Override
        public String toXml(Object domainObject) {
            return this.toXml(domainObject, Maps.newHashMap());
        }

        @Override
        public String toXml(Object domainObject, Map<String, Object> marshallerProperties) {
            Class<?> domainClass = domainObject.getClass();
            JAXBContext context = this.jaxbContextFor(domainObject);
            try {
                Marshaller marshaller = context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                for (Map.Entry<String, Object> entry : marshallerProperties.entrySet()) {
                    marshaller.setProperty(entry.getKey(), entry.getValue());
                }
                this.configure(marshaller);
                StringWriter sw = new StringWriter();
                marshaller.marshal(domainObject, (Writer)sw);
                String xml = sw.toString();
                return xml;
            }
            catch (JAXBException ex) {
                Class<?> exClass = ((Object)((Object)ex)).getClass();
                String name = exClass.getName();
                if (name.equals("com.sun.xml.bind.v2.runtime.IllegalAnnotationsException")) {
                    List errors = null;
                    String annotationExceptionMessages = null;
                    try {
                        Method getErrorsMethod = exClass.getMethod("getErrors", new Class[0]);
                        errors = (List)getErrorsMethod.invoke((Object)ex, new Object[0]);
                        annotationExceptionMessages = ": " + Joiner.on((String)"; ").join(Iterables.transform((Iterable)errors, (Function)new Function<Exception, String>(){

                            public String apply(Exception e) {
                                return e.getMessage();
                            }
                        }));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (errors != null) {
                        throw new NonRecoverableException("Error marshalling domain object to XML, due to illegal annotations on domain object class '" + domainClass.getName() + "'; " + errors.size() + " error" + (errors.size() == 1 ? "" : "s") + " reported" + (!errors.isEmpty() ? annotationExceptionMessages : ""), ex);
                    }
                }
                throw new NonRecoverableException("Error marshalling domain object to XML; domain object class is '" + domainClass.getName() + "'", ex);
            }
        }

        protected JAXBContext jaxbContextFor(Object domainObject) {
            Class<?> domainClass = domainObject.getClass();
            JAXBContext context = Simple.jaxbContextFor(domainClass);
            return context;
        }

        protected void configure(Unmarshaller unmarshaller) {
        }

        protected void configure(Marshaller marshaller) {
        }

        @Override
        public Map<String, String> toXsd(Object domainObject, IsisSchemas isisSchemas) {
            try {
                Class<?> domainClass = domainObject.getClass();
                JAXBContext context = Simple.jaxbContextFor(domainClass);
                CatalogingSchemaOutputResolver outputResolver = new CatalogingSchemaOutputResolver(isisSchemas);
                context.generateSchema((SchemaOutputResolver)outputResolver);
                return outputResolver.asMap();
            }
            catch (IOException ex) {
                throw new ApplicationException(ex);
            }
        }
    }

    public static enum IsisSchemas {
        INCLUDE,
        IGNORE;


        public boolean shouldIgnore(String namespaceUri) {
            if (this == INCLUDE) {
                return false;
            }
            return namespaceUri.matches(".*isis\\.apache\\.org.*");
        }
    }
}

