/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.hsqldb;

import com.google.common.base.Strings;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.hsqldb.util.DatabaseManagerSwing;

@DomainService(nature=NatureOfService.VIEW_MENU_ONLY, objectType="isisApplib.HsqlDbManagerMenu")
@DomainServiceLayout(named="Prototyping", menuOrder="500.800", menuBar=DomainServiceLayout.MenuBar.SECONDARY)
public class HsqlDbManagerMenu {
    private String url;

    @PostConstruct
    public void init(Map<String, String> properties) {
        this.url = properties.get("isis.persistor.datanucleus.impl.javax.jdo.option.ConnectionURL");
    }

    @Action(semantics=SemanticsOf.SAFE, restrictTo=RestrictTo.PROTOTYPING, domainEvent=ActionDomainEvent.class)
    @ActionLayout(named="HSQL DB Manager", cssClassFa="database")
    public void hsqlDbManager() {
        String[] args = new String[]{"--url", this.url, "--noexit"};
        DatabaseManagerSwing.main((String[])args);
    }

    public boolean hideHsqlDbManager() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(DatabaseManagerSwing.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        return Strings.isNullOrEmpty((String)this.url) || !this.url.contains("hsqldb:mem");
    }

    public static class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<HsqlDbManagerMenu> {
    }
}

