/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.exceprecog;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer2;
import org.apache.isis.applib.services.exceprecog.TranslatableException;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExceptionRecognizerAbstract
implements ExceptionRecognizer2 {
    public static final Logger LOG = LoggerFactory.getLogger(ExceptionRecognizerAbstract.class);
    private static final String KEY_LOG_RECOGNIZED_EXCEPTIONS = "isis.services.exceprecog.logRecognizedExceptions";
    private final ExceptionRecognizer2.Category category;
    private final Predicate<Throwable> predicate;
    private final Function<String, String> messageParser;
    private boolean logRecognizedExceptions;
    @Inject
    protected TranslationService translationService;

    protected static Function<String, String> constant(final String message) {
        return new Function<String, String>(){

            public String apply(String input) {
                return message;
            }
        };
    }

    protected static Function<String, String> prefix(final String prefix) {
        return new Function<String, String>(){

            public String apply(String input) {
                return prefix + ": " + input;
            }
        };
    }

    public ExceptionRecognizerAbstract(ExceptionRecognizer2.Category category, Predicate<Throwable> predicate, Function<String, String> messageParser) {
        this.category = category;
        this.predicate = predicate;
        this.messageParser = messageParser != null ? messageParser : Functions.identity();
    }

    public ExceptionRecognizerAbstract(Predicate<Throwable> predicate, Function<String, String> messageParser) {
        this(ExceptionRecognizer2.Category.OTHER, predicate, messageParser);
    }

    public ExceptionRecognizerAbstract(ExceptionRecognizer2.Category category, Predicate<Throwable> predicate) {
        this(category, predicate, null);
    }

    public ExceptionRecognizerAbstract(Predicate<Throwable> predicate) {
        this(ExceptionRecognizer2.Category.OTHER, predicate);
    }

    @Override
    @PostConstruct
    public void init(Map<String, String> properties) {
        String prop = properties.get(KEY_LOG_RECOGNIZED_EXCEPTIONS);
        this.logRecognizedExceptions = Boolean.parseBoolean(prop);
    }

    @Override
    @PreDestroy
    public void shutdown() {
    }

    @Override
    @Programmatic
    public String recognize(Throwable ex) {
        List causalChain = Throwables.getCausalChain((Throwable)ex);
        for (Throwable throwable : causalChain) {
            if (!this.predicate.apply((Object)throwable)) continue;
            if (this.logRecognizedExceptions) {
                LOG.info("Recognized exception, stacktrace : ", throwable);
            }
            if (ex instanceof TranslatableException) {
                TranslatableException translatableException = (TranslatableException)((Object)ex);
                TranslatableString translatableMessage = translatableException.getTranslatableMessage();
                String translationContext = translatableException.getTranslationContext();
                if (translatableMessage != null && translationContext != null) {
                    return translatableMessage.translate(this.translationService, translationContext);
                }
            }
            Throwable rootCause = Throwables.getRootCause((Throwable)throwable);
            String rootCauseMessage = rootCause.getMessage();
            String parsedMessage = (String)this.messageParser.apply((Object)rootCauseMessage);
            return parsedMessage;
        }
        return null;
    }

    @Override
    @Programmatic
    public ExceptionRecognizer2.Recognition recognize2(Throwable ex) {
        return ExceptionRecognizer2.Recognition.of(this.category, this.recognize(ex));
    }
}

