/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.config;

import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.Title;

@XmlRootElement(name="configurationProperty")
@XmlType(propOrder={"key", "value"})
@DomainObject(editing=Editing.DISABLED, objectType="isisApplib.ConfigurationProperty")
@DomainObjectLayout(paged=999)
public class ConfigurationProperty
implements Comparable<ConfigurationProperty> {
    private String key;
    private String value;

    public ConfigurationProperty() {
    }

    public ConfigurationProperty(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @XmlElement(required=true)
    @Title
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @XmlElement(required=true)
    public String getValue() {
        return Util.maskIfProtected(this.key, this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public int compareTo(ConfigurationProperty other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.getKey()), (Comparable)((Object)other.getKey())).result();
    }

    public static class Util {
        private static final List<String> PROTECTED_KEYS = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"password", "apiKey", "authToken"}));

        private Util() {
        }

        static boolean isProtected(String key) {
            if (Strings.isNullOrEmpty((String)key)) {
                return false;
            }
            String toLowerCase = key.toLowerCase();
            for (String protectedKey : PROTECTED_KEYS) {
                if (!toLowerCase.contains(protectedKey.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        public static String maskIfProtected(String key, String value) {
            return Util.isProtected(key) ? "********" : value;
        }
    }
}

