/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.services.audit;

import java.sql.Timestamp;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.audit.AuditerService;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class AuditerServiceLogging
implements AuditerService {
    private static final Logger LOG = LoggerFactory.getLogger(AuditerServiceLogging.class);

    @PostConstruct
    public void init() {
    }

    @Override
    public boolean isEnabled() {
        return LOG.isDebugEnabled();
    }

    @Override
    @Programmatic
    public void audit(UUID interactionId, int sequence, String targetClassName, Bookmark target, String memberId, String propertyName, String preValue, String postValue, String user, Timestamp timestamp) {
        String auditMessage = interactionId + "," + sequence + ": " + target.toString() + " by " + user + ", " + propertyName + ": " + preValue + " -> " + postValue;
        LOG.debug(auditMessage);
    }
}

