/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.isis.applib.annotation.MemberOrder;
import org.apache.isis.applib.annotation.NotPersistable;
import org.apache.isis.applib.security.RoleMemento;

@NotPersistable
public final class UserMemento {
    private final String name;
    private final List<RoleMemento> roles = new ArrayList<RoleMemento>();

    public UserMemento(String name) {
        this(name, new RoleMemento[0]);
    }

    public UserMemento(String name, RoleMemento ... roles) {
        this(name, Arrays.asList(roles));
    }

    public UserMemento(String name, List<RoleMemento> roles) {
        if (name == null) {
            throw new IllegalArgumentException("Name not specified");
        }
        this.name = name;
        this.roles.addAll(roles);
    }

    public String title() {
        return this.name;
    }

    @MemberOrder(sequence="1.1")
    public String getName() {
        return this.name;
    }

    public boolean isCurrentUser(String userName) {
        if (userName == null) {
            throw new IllegalArgumentException("no user name provided");
        }
        return this.name.equals(userName);
    }

    @MemberOrder(sequence="1.1")
    public List<RoleMemento> getRoles() {
        return this.roles;
    }

    public boolean hasRole(RoleMemento role) {
        return this.hasRole(role.getName());
    }

    public boolean hasRole(String roleName) {
        for (RoleMemento role : this.roles) {
            if (!role.getName().matches(roleName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (RoleMemento role : this.roles) {
            buf.append(role.getName()).append(" ");
        }
        return "User [name=" + this.getName() + ",roles=" + buf.toString() + "]";
    }

    public static class NameType {
        private NameType() {
        }

        public static class Meta {
            public static final int MAX_LEN = 50;

            private Meta() {
            }
        }
    }
}

