/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.grid.bootstrap3;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.layout.grid.bootstrap3.Size;

@XmlType(name="sizeSpan", propOrder={})
public class SizeSpan
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Size size;
    private int span;
    private Boolean offset;

    public static SizeSpan with(Size size, int span) {
        SizeSpan ss = new SizeSpan();
        ss.setSize(size);
        ss.setSpan(span);
        return ss;
    }

    public static SizeSpan offset(Size size, int span) {
        SizeSpan ss = SizeSpan.with(size, span);
        ss.setOffset(true);
        return ss;
    }

    @XmlAttribute(required=true)
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    @XmlAttribute(required=true)
    public int getSpan() {
        return this.span;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    @XmlAttribute(required=false)
    public Boolean isOffset() {
        return this.offset;
    }

    public void setOffset(Boolean offset) {
        this.offset = offset;
    }

    public String toCssClassFragment() {
        return this.appendCssClassFragment(new StringBuilder()).toString();
    }

    public StringBuilder appendCssClassFragment(StringBuilder buf) {
        if (buf.length() > 0) {
            buf.append(" ");
        }
        buf.append("col-").append(this.size.toCssClassFragment()).append("-").append(this.offset != null && this.offset != false ? "offset-" : "").append(this.span);
        return buf;
    }
}

