/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.grid.bootstrap3;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3ElementAbstract;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Grid;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Row;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3RowOwner;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabOwner;

@XmlType(name="tab", propOrder={"name", "rows"})
public class BS3Tab
extends BS3ElementAbstract
implements BS3RowOwner {
    private static final long serialVersionUID = 1L;
    private String name;
    private List<BS3Row> rows = Lists.newArrayList();
    private BS3TabOwner owner;

    @XmlAttribute(required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @XmlElement(name="row", required=true)
    public List<BS3Row> getRows() {
        return this.rows;
    }

    public void setRows(List<BS3Row> rows) {
        this.rows = rows;
    }

    @XmlTransient
    public BS3TabOwner getOwner() {
        return this.owner;
    }

    public void setOwner(BS3TabOwner owner) {
        this.owner = owner;
    }

    @Override
    @XmlTransient
    @Programmatic
    public BS3Grid getGrid() {
        return this.getOwner().getGrid();
    }

    public String toString() {
        return "BS3Tab{name='" + this.name + '\'' + '}';
    }

    public static class Predicates {
        public static Predicate<BS3Tab> notEmpty() {
            final AtomicBoolean visitingTheNode = new AtomicBoolean(false);
            final AtomicBoolean foundContent = new AtomicBoolean(false);
            return new Predicate<BS3Tab>(){

                public boolean apply(final BS3Tab thisBs3Tab) {
                    BS3Grid owningGrid = thisBs3Tab.getGrid();
                    owningGrid.visit(new BS3Grid.VisitorAdapter(){

                        @Override
                        public void preVisit(BS3Tab bs3Tab) {
                            if (bs3Tab == thisBs3Tab) {
                                foundContent.set(false);
                                visitingTheNode.set(true);
                            }
                        }

                        @Override
                        public void postVisit(BS3Tab bs3Tab) {
                            if (bs3Tab == thisBs3Tab) {
                                visitingTheNode.set(false);
                            }
                        }

                        @Override
                        public void visit(DomainObjectLayoutData domainObjectLayoutData) {
                            if (visitingTheNode.get()) {
                                foundContent.set(true);
                            }
                        }

                        @Override
                        public void visit(ActionLayoutData actionLayoutData) {
                            if (visitingTheNode.get()) {
                                foundContent.set(true);
                            }
                        }

                        @Override
                        public void visit(PropertyLayoutData propertyLayoutData) {
                            if (visitingTheNode.get()) {
                                foundContent.set(true);
                            }
                        }

                        @Override
                        public void visit(CollectionLayoutData collectionLayoutData) {
                            if (visitingTheNode.get()) {
                                foundContent.set(true);
                            }
                        }
                    });
                    return foundContent.get();
                }
            };
        }
    }
}

