/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.layout.grid.bootstrap3;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.layout.grid.GridAbstract;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3ClearFix;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Col;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Element;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Row;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3RowContent;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3RowOwner;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Tab;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabGroup;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabGroupOwner;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabOwner;
import org.apache.isis.applib.layout.grid.bootstrap3.HasCssId;
import org.apache.isis.applib.services.dto.Dto;

@XmlRootElement(name="grid")
@XmlType(name="grid", propOrder={"rows", "metadataErrors"})
public class BS3Grid
extends GridAbstract
implements BS3Element,
Dto,
BS3RowOwner {
    private static final long serialVersionUID = 1L;
    private String cssClass;
    private List<BS3Row> rows = Lists.newArrayList();
    private List<String> metadataErrors = Lists.newArrayList();
    private BS3RowOwner owner;

    @Override
    @XmlAttribute(required=false)
    public String getCssClass() {
        return this.cssClass;
    }

    @Override
    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    @Override
    @XmlElement(name="row", required=true)
    public List<BS3Row> getRows() {
        return this.rows;
    }

    public void setRows(List<BS3Row> rows) {
        this.rows = rows;
    }

    @XmlElement(name="metadataError", required=false)
    public List<String> getMetadataErrors() {
        return this.metadataErrors;
    }

    public void setMetadataErrors(List<String> metadataErrors) {
        this.metadataErrors = metadataErrors;
    }

    @Override
    public void visit(Grid.Visitor visitor) {
        Visitor bs3Visitor = BS3Grid.asBs3Visitor(visitor);
        bs3Visitor.preVisit(this);
        bs3Visitor.visit(this);
        this.traverseRows(this, visitor);
        bs3Visitor.postVisit(this);
    }

    protected void traverseRows(BS3RowOwner rowOwner, Grid.Visitor visitor) {
        Visitor bs3Visitor = BS3Grid.asBs3Visitor(visitor);
        List<BS3Row> rows = rowOwner.getRows();
        for (BS3Row bs3Row : Lists.newArrayList(rows)) {
            bs3Row.setOwner(this);
            bs3Visitor.preVisit(bs3Row);
            bs3Visitor.visit(bs3Row);
            this.traverseCols(visitor, bs3Row);
            bs3Visitor.postVisit(bs3Row);
        }
    }

    private void traverseCols(Grid.Visitor visitor, BS3Row bs3Row) {
        Visitor bs3Visitor = BS3Grid.asBs3Visitor(visitor);
        List<BS3RowContent> cols = bs3Row.getCols();
        for (BS3RowContent rowContent : Lists.newArrayList(cols)) {
            rowContent.setOwner(bs3Row);
            if (rowContent instanceof BS3Col) {
                BS3Col bs3Col = (BS3Col)rowContent;
                bs3Visitor.preVisit(bs3Col);
                bs3Visitor.visit(bs3Col);
                this.traverseDomainObject(bs3Col, visitor);
                this.traverseTabGroups(bs3Col, visitor);
                this.traverseActions(bs3Col, visitor);
                this.traverseFieldSets(bs3Col, visitor);
                this.traverseCollections(bs3Col, visitor);
                this.traverseRows(bs3Col, visitor);
                bs3Visitor.postVisit(bs3Col);
                continue;
            }
            if (rowContent instanceof BS3ClearFix) {
                BS3ClearFix bs3ClearFix = (BS3ClearFix)rowContent;
                bs3Visitor.visit(bs3ClearFix);
                continue;
            }
            throw new IllegalStateException("Unrecognized implementation of BS3RowContent, " + rowContent);
        }
    }

    private void traverseDomainObject(BS3Col bs3Col, Grid.Visitor visitor) {
        DomainObjectLayoutData domainObject = bs3Col.getDomainObject();
        if (domainObject == null) {
            return;
        }
        domainObject.setOwner(bs3Col);
        visitor.visit(domainObject);
    }

    private void traverseTabGroups(BS3TabGroupOwner bs3TabGroupOwner, Grid.Visitor visitor) {
        Visitor bs3Visitor = BS3Grid.asBs3Visitor(visitor);
        List<BS3TabGroup> tabGroups = bs3TabGroupOwner.getTabGroups();
        for (BS3TabGroup bs3TabGroup : Lists.newArrayList(tabGroups)) {
            bs3TabGroup.setOwner(bs3TabGroupOwner);
            bs3Visitor.preVisit(bs3TabGroup);
            bs3Visitor.visit(bs3TabGroup);
            this.traverseTabs(bs3TabGroup, visitor);
            bs3Visitor.postVisit(bs3TabGroup);
        }
    }

    private void traverseTabs(BS3TabOwner bs3TabOwner, Grid.Visitor visitor) {
        Visitor bs3Visitor = BS3Grid.asBs3Visitor(visitor);
        List<BS3Tab> tabs = bs3TabOwner.getTabs();
        for (BS3Tab tab : Lists.newArrayList(tabs)) {
            tab.setOwner(bs3TabOwner);
            bs3Visitor.preVisit(tab);
            bs3Visitor.visit(tab);
            this.traverseRows(tab, visitor);
            bs3Visitor.postVisit(tab);
        }
    }

    private static Visitor asBs3Visitor(final Grid.Visitor visitor) {
        return visitor instanceof Visitor ? (Visitor)visitor : new VisitorAdapter(){

            @Override
            public void visit(DomainObjectLayoutData domainObjectLayoutData) {
                visitor.visit(domainObjectLayoutData);
            }

            @Override
            public void visit(ActionLayoutData actionLayoutData) {
                visitor.visit(actionLayoutData);
            }

            @Override
            public void visit(PropertyLayoutData propertyLayoutData) {
                visitor.visit(propertyLayoutData);
            }

            @Override
            public void visit(CollectionLayoutData collectionLayoutData) {
                visitor.visit(collectionLayoutData);
            }

            @Override
            public void visit(FieldSet fieldSet) {
                visitor.visit(fieldSet);
            }
        };
    }

    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, BS3Tab> getAllTabsByName() {
        final LinkedHashMap tabsByName = Maps.newLinkedHashMap();
        this.visit(new VisitorAdapter(){

            @Override
            public void visit(BS3Tab bS3Tab) {
                tabsByName.put(bS3Tab.getName(), bS3Tab);
            }
        });
        return tabsByName;
    }

    @Programmatic
    @XmlTransient
    public LinkedHashMap<String, HasCssId> getAllCssId() {
        final LinkedHashMap divsByCssId = Maps.newLinkedHashMap();
        this.visit(new VisitorAdapter(){

            @Override
            public void visit(BS3Row bs3Row) {
                String id = bs3Row.getId();
                divsByCssId.put(id, bs3Row);
            }
        });
        return divsByCssId;
    }

    @Override
    @Programmatic
    @XmlTransient
    public BS3Grid getGrid() {
        return this;
    }

    public static class VisitorAdapter
    extends Grid.VisitorAdapter
    implements Visitor {
        @Override
        public void preVisit(BS3Grid bs3Grid) {
        }

        @Override
        public void visit(BS3Grid bs3Grid) {
        }

        @Override
        public void postVisit(BS3Grid bs3Grid) {
        }

        @Override
        public void preVisit(BS3Row bs3Row) {
        }

        @Override
        public void visit(BS3Row bs3Row) {
        }

        @Override
        public void postVisit(BS3Row bs3Row) {
        }

        @Override
        public void preVisit(BS3Col bs3Col) {
        }

        @Override
        public void visit(BS3Col bs3Col) {
        }

        @Override
        public void postVisit(BS3Col bs3Col) {
        }

        @Override
        public void visit(BS3ClearFix bs3ClearFix) {
        }

        @Override
        public void preVisit(BS3TabGroup bs3TabGroup) {
        }

        @Override
        public void visit(BS3TabGroup bs3TabGroup) {
        }

        @Override
        public void postVisit(BS3TabGroup bs3TabGroup) {
        }

        @Override
        public void preVisit(BS3Tab bs3Tab) {
        }

        @Override
        public void visit(BS3Tab bs3Tab) {
        }

        @Override
        public void postVisit(BS3Tab bs3Tab) {
        }
    }

    public static interface Visitor
    extends Grid.Visitor {
        public void preVisit(BS3Grid var1);

        public void visit(BS3Grid var1);

        public void postVisit(BS3Grid var1);

        public void preVisit(BS3Row var1);

        public void visit(BS3Row var1);

        public void postVisit(BS3Row var1);

        public void preVisit(BS3Col var1);

        public void visit(BS3Col var1);

        public void postVisit(BS3Col var1);

        public void visit(BS3ClearFix var1);

        public void preVisit(BS3TabGroup var1);

        public void visit(BS3TabGroup var1);

        public void postVisit(BS3TabGroup var1);

        public void preVisit(BS3Tab var1);

        public void visit(BS3Tab var1);

        public void postVisit(BS3Tab var1);
    }
}

