/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts.teardown;

import com.google.common.base.Strings;
import javax.inject.Inject;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.metadata.DiscriminatorMetadata;
import javax.jdo.metadata.InheritanceMetadata;
import javax.jdo.metadata.TypeMetadata;
import org.apache.isis.applib.fixturescripts.teardown.TeardownFixtureAbstract;
import org.apache.isis.applib.services.jdosupport.IsisJdoSupport;

public abstract class TeardownFixtureAbstract2
extends TeardownFixtureAbstract {
    @Inject
    protected IsisJdoSupport isisJdoSupport;

    @Override
    protected void deleteFrom(Class cls) {
        String column = this.discriminatorColumnOf(cls);
        String value = this.discriminatorValueOf(cls);
        if (column == null || value == null) {
            this.superDeleteFrom(cls);
            return;
        }
        String schema = this.schemaOf(cls);
        String table = this.tableOf(cls);
        this.preDeleteFrom(cls);
        if (Strings.isNullOrEmpty((String)schema)) {
            this.deleteFromWhere(table, column, value);
        } else {
            this.deleteFromWhere(schema, table, column, value);
        }
        this.postDeleteFrom(cls);
    }

    protected String schemaOf(Class cls) {
        TypeMetadata metadata = this.getPersistenceManagerFactory().getMetadata(cls.getName());
        if (metadata == null) {
            return null;
        }
        InheritanceMetadata inheritanceMetadata = metadata.getInheritanceMetadata();
        if (inheritanceMetadata != null && inheritanceMetadata.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            return this.schemaOf(cls.getSuperclass());
        }
        return metadata.getSchema();
    }

    protected String tableOf(Class cls) {
        TypeMetadata metadata = this.getPersistenceManagerFactory().getMetadata(cls.getName());
        if (metadata == null) {
            return cls.getSimpleName();
        }
        InheritanceMetadata inheritanceMetadata = metadata.getInheritanceMetadata();
        if (inheritanceMetadata != null && inheritanceMetadata.getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            return this.tableOf(cls.getSuperclass());
        }
        String table = metadata.getTable();
        return !Strings.isNullOrEmpty((String)table) ? table : cls.getSimpleName();
    }

    protected String discriminatorValueOf(Class cls) {
        TypeMetadata metadata = this.getPersistenceManagerFactory().getMetadata(cls.getName());
        if (metadata == null) {
            return null;
        }
        InheritanceMetadata inheritanceMetadata = metadata.getInheritanceMetadata();
        if (inheritanceMetadata == null || inheritanceMetadata.getStrategy() != InheritanceStrategy.SUPERCLASS_TABLE) {
            return null;
        }
        DiscriminatorMetadata discriminatorMetadata = inheritanceMetadata.getDiscriminatorMetadata();
        if (discriminatorMetadata == null || discriminatorMetadata.getStrategy() != DiscriminatorStrategy.VALUE_MAP) {
            return null;
        }
        return discriminatorMetadata.getValue();
    }

    protected String discriminatorColumnOf(Class cls) {
        String discriminator = this.doDiscriminatorOf(cls);
        return discriminator != null ? discriminator : "discriminator";
    }

    private String doDiscriminatorOf(Class cls) {
        TypeMetadata metadata = this.getPersistenceManagerFactory().getMetadata(cls.getName());
        if (metadata == null) {
            return null;
        }
        InheritanceMetadata inheritanceMetadata = metadata.getInheritanceMetadata();
        if (inheritanceMetadata == null || inheritanceMetadata.getStrategy() != InheritanceStrategy.SUPERCLASS_TABLE) {
            return null;
        }
        DiscriminatorMetadata discriminatorMetadata = inheritanceMetadata.getDiscriminatorMetadata();
        if (discriminatorMetadata == null || discriminatorMetadata.getStrategy() != DiscriminatorStrategy.VALUE_MAP) {
            return null;
        }
        return discriminatorMetadata.getColumn();
    }

    private PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.isisJdoSupport.getJdoPersistenceManager().getPersistenceManagerFactory();
    }

    private void superDeleteFrom(Class cls) {
        super.deleteFrom(cls);
    }

    protected Integer deleteFromWhere(String schema, String table, String column, String value) {
        String sql = String.format("DELETE FROM \"%s\".\"%s\" WHERE \"%s\"='%s'", schema, table, column, value);
        return this.isisJdoSupport.executeUpdate(sql);
    }

    protected void deleteFromWhere(String table, String column, String value) {
        String sql = String.format("DELETE FROM \"%s\" WHERE \"%s\"='%s'", table, column, value);
        this.isisJdoSupport.executeUpdate(sql);
    }

    @Override
    protected void preDeleteFrom(Class cls) {
    }

    @Override
    protected void postDeleteFrom(Class cls) {
    }
}

