/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts.clock;

import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.applib.fixtures.TickingFixtureClock;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScriptWithExecutionStrategy;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Programmatic
public class TickingClockFixture
extends FixtureScript
implements FixtureScriptWithExecutionStrategy {
    private String date;

    public String getDate() {
        return this.date;
    }

    public TickingClockFixture setDate(String date) {
        this.date = date;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(FixtureScript.ExecutionContext ec) {
        this.checkParam("date", ec, String.class);
        Clock instance = Clock.getInstance();
        if (instance instanceof TickingFixtureClock) {
            try {
                TickingFixtureClock.reinstateExisting();
                this.setTo(this.date);
            }
            finally {
                TickingFixtureClock.replaceExisting();
            }
        }
        if (instance instanceof FixtureClock) {
            this.setTo(this.date);
        }
    }

    private void setTo(String date) {
        if (!(Clock.getInstance() instanceof FixtureClock)) {
            throw new IllegalStateException("Clock has not been initialized as a FixtureClock");
        }
        FixtureClock fixtureClock = (FixtureClock)FixtureClock.getInstance();
        LocalDateTime ldt = TickingClockFixture.parseAsLocalDateTime(date);
        if (ldt != null) {
            fixtureClock.setDate(ldt.getYear(), ldt.getMonthOfYear(), ldt.getDayOfMonth());
            fixtureClock.setTime(ldt.getHourOfDay(), ldt.getMinuteOfHour());
            return;
        }
        LocalDate ld = TickingClockFixture.parseAsLocalDate(date);
        if (ld != null) {
            fixtureClock.setDate(ld.getYear(), ld.getMonthOfYear(), ld.getDayOfMonth());
            return;
        }
        throw new IllegalArgumentException(String.format("'%s' could not be parsed as a local date/time or local date", date));
    }

    private static LocalDate parseAsLocalDate(String dateStr) {
        for (DateTimeFormatter formatter : new DateTimeFormatter[]{DateTimeFormat.fullDateTime(), DateTimeFormat.mediumDateTime(), DateTimeFormat.shortDateTime(), DateTimeFormat.forPattern((String)"yyyy-MM-dd"), DateTimeFormat.forPattern((String)"yyyyMMdd")}) {
            try {
                return formatter.parseLocalDate(dateStr);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static LocalDateTime parseAsLocalDateTime(String dateStr) {
        for (DateTimeFormatter formatter : new DateTimeFormatter[]{DateTimeFormat.fullDateTime(), DateTimeFormat.mediumDateTime(), DateTimeFormat.shortDateTime(), DateTimeFormat.forPattern((String)"yyyyMMddhhmmss"), DateTimeFormat.forPattern((String)"yyyyMMddhhmm")}) {
            try {
                return formatter.parseLocalDateTime(dateStr);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Override
    public FixtureScripts.MultipleExecutionStrategy getMultipleExecutionStrategy() {
        return FixtureScripts.MultipleExecutionStrategy.EXECUTE;
    }
}

