/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts.clock;

import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScriptWithExecutionStrategy;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Programmatic
class ClockFixture
extends FixtureScript
implements FixtureScriptWithExecutionStrategy {
    private String date;

    static ClockFixture setTo(String date) {
        return new ClockFixture().setDate(date);
    }

    ClockFixture() {
        super(null, "clock");
    }

    public String getDate() {
        return this.date;
    }

    public ClockFixture setDate(String date) {
        this.date = date;
        return this;
    }

    @Override
    protected void execute(FixtureScript.ExecutionContext ec) {
        if (!(Clock.getInstance() instanceof FixtureClock)) {
            throw new IllegalStateException("Clock has not been initialized as a FixtureClock");
        }
        FixtureClock fixtureClock = (FixtureClock)FixtureClock.getInstance();
        this.checkParam("date", ec, String.class);
        LocalDateTime ldt = ClockFixture.parseAsLocalDateTime(this.date);
        if (ldt != null) {
            fixtureClock.setDate(ldt.getYear(), ldt.getMonthOfYear(), ldt.getDayOfMonth());
            fixtureClock.setTime(ldt.getHourOfDay(), ldt.getMinuteOfHour());
            return;
        }
        LocalDate ld = ClockFixture.parseAsLocalDate(this.date);
        if (ld != null) {
            fixtureClock.setDate(ld.getYear(), ld.getMonthOfYear(), ld.getDayOfMonth());
            return;
        }
        throw new IllegalArgumentException(String.format("'%s' could not be parsed as a local date/time or local date", this.date));
    }

    private static LocalDate parseAsLocalDate(String dateStr) {
        for (DateTimeFormatter formatter : new DateTimeFormatter[]{DateTimeFormat.fullDateTime(), DateTimeFormat.mediumDateTime(), DateTimeFormat.shortDateTime(), DateTimeFormat.forPattern((String)"yyyy-MM-dd"), DateTimeFormat.forPattern((String)"yyyyMMdd")}) {
            try {
                return formatter.parseLocalDate(dateStr);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static LocalDateTime parseAsLocalDateTime(String dateStr) {
        for (DateTimeFormatter formatter : new DateTimeFormatter[]{DateTimeFormat.fullDateTime(), DateTimeFormat.mediumDateTime(), DateTimeFormat.shortDateTime(), DateTimeFormat.forPattern((String)"yyyyMMddhhmmss"), DateTimeFormat.forPattern((String)"yyyyMMddhhmm")}) {
            try {
                return formatter.parseLocalDateTime(dateStr);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Override
    public FixtureScripts.MultipleExecutionStrategy getMultipleExecutionStrategy() {
        return FixtureScripts.MultipleExecutionStrategy.EXECUTE;
    }
}

