/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.fixturescripts;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.fixturescripts.FixtureScriptWithExecutionStrategy;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.fixturescripts.PersonaWithBuilderScript;
import org.apache.isis.applib.fixturescripts.PersonaWithFinder;
import org.apache.isis.applib.fixturescripts.WithPrereqs;

@Programmatic
public abstract class BuilderScriptAbstract<T, F extends BuilderScriptAbstract<T, F>>
extends FixtureScript
implements WithPrereqs<T, F>,
FixtureScriptWithExecutionStrategy {
    private final FixtureScripts.MultipleExecutionStrategy executionStrategy;
    private final List<WithPrereqs.Block<T, F>> prereqs = Lists.newArrayList();

    protected BuilderScriptAbstract() {
        this(FixtureScripts.MultipleExecutionStrategy.EXECUTE_ONCE_BY_VALUE);
    }

    protected BuilderScriptAbstract(FixtureScripts.MultipleExecutionStrategy executionStrategy) {
        this.executionStrategy = executionStrategy;
    }

    @Override
    public FixtureScripts.MultipleExecutionStrategy getMultipleExecutionStrategy() {
        return this.executionStrategy;
    }

    @Programmatic
    public F build(FixtureScript parentFixtureScript, FixtureScript.ExecutionContext executionContext) {
        BuilderScriptAbstract onFixture = this;
        parentFixtureScript.container.injectServicesInto(onFixture);
        this.execPrereqs(executionContext);
        return (F)executionContext.executeChildT(parentFixtureScript, this);
    }

    @Override
    public void execPrereqs(FixtureScript.ExecutionContext executionContext) {
        BuilderScriptAbstract onFixture = this;
        for (WithPrereqs.Block<T, BuilderScriptAbstract> block : this.prereqs) {
            block.execute(onFixture, executionContext);
        }
    }

    @Override
    protected abstract void execute(FixtureScript.ExecutionContext var1);

    public abstract T getObject();

    public <P extends PersonaWithBuilderScript<T, F>, T, F extends BuilderScriptAbstract<T, F>> T objectFor(P persona, FixtureScript.ExecutionContext ec) {
        if (persona == null) {
            return null;
        }
        F fixtureScript = persona.builder();
        return ((BuilderScriptAbstract)ec.executeChildT(this, fixtureScript)).getObject();
    }

    public <P extends PersonaWithFinder<T>, T> T findUsing(P persona) {
        if (persona == null) {
            return null;
        }
        return persona.findUsing(this.serviceRegistry);
    }

    @Override
    public F setPrereq(WithPrereqs.Block<T, F> prereq) {
        this.prereqs.add(prereq);
        return (F)this;
    }
}

