/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.domain;

import com.google.common.collect.Lists;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.isis.applib.IsisApplibModule;
import org.apache.isis.applib.annotation.Collection;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.schema.utils.jaxbadapters.PersistentEntitiesAdapter;

@XmlRootElement(name="list")
@XmlType(propOrder={"title", "actionOwningType", "actionId", "actionArguments", "elementObjectType", "objects"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@DomainObject(objectType="isisApplib.DomainObjectList", editing=Editing.DISABLED, nature=Nature.VIEW_MODEL)
@DomainObjectLayout(titleUiEvent=TitleUiEvent.class, iconUiEvent=IconUiEvent.class, cssClassUiEvent=CssClassUiEvent.class)
public class DomainObjectList {
    private String title;
    private String elementObjectType;
    private String actionOwningType;
    private String actionId;
    private String actionArguments;
    @XmlJavaTypeAdapter(value=PersistentEntitiesAdapter.class)
    private List<Object> objects = Lists.newArrayList();

    public DomainObjectList() {
    }

    public DomainObjectList(String title, String elementObjectType, String actionOwningType, String actionId, String actionArguments) {
        this.title = title;
        this.elementObjectType = elementObjectType;
        this.actionOwningType = actionOwningType;
        this.actionId = actionId;
        this.actionArguments = actionArguments;
    }

    public String title() {
        return this.title;
    }

    @Property(domainEvent=ElementObjectTypeDomainEvent.class, editing=Editing.DISABLED)
    public String getElementObjectType() {
        return this.elementObjectType;
    }

    @Property(domainEvent=ActionOwningTypeDomainEvent.class, optionality=Optionality.OPTIONAL, editing=Editing.DISABLED)
    public String getActionOwningType() {
        return this.actionOwningType;
    }

    @Property(domainEvent=ActionIdDomainEvent.class, optionality=Optionality.OPTIONAL, editing=Editing.DISABLED)
    public String getActionId() {
        return this.actionId;
    }

    @Property(domainEvent=ActionArgumentsDomainEvent.class, optionality=Optionality.OPTIONAL, editing=Editing.DISABLED)
    public String getActionArguments() {
        return this.actionArguments;
    }

    @Collection(domainEvent=ObjectsDomainEvent.class, editing=Editing.DISABLED)
    public List<Object> getObjects() {
        return this.objects;
    }

    public void setObjects(List<Object> objects) {
        this.objects = objects;
    }

    public static class ObjectsDomainEvent
    extends CollectionDomainEvent<Object> {
    }

    public static class ActionArgumentsDomainEvent
    extends PropertyDomainEvent<String> {
    }

    public static class ActionIdDomainEvent
    extends PropertyDomainEvent<String> {
    }

    public static class ActionOwningTypeDomainEvent
    extends PropertyDomainEvent<String> {
    }

    public static class ElementObjectTypeDomainEvent
    extends PropertyDomainEvent<String> {
    }

    public static abstract class ActionDomainEvent
    extends IsisApplibModule.ActionDomainEvent<DomainObjectList> {
    }

    public static abstract class CollectionDomainEvent<T>
    extends IsisApplibModule.CollectionDomainEvent<DomainObjectList, T> {
    }

    public static abstract class PropertyDomainEvent<T>
    extends IsisApplibModule.PropertyDomainEvent<DomainObjectList, T> {
    }

    public static class CssClassUiEvent
    extends IsisApplibModule.CssClassUiEvent<DomainObjectList> {
    }

    public static class IconUiEvent
    extends IsisApplibModule.IconUiEvent<DomainObjectList> {
    }

    public static class TitleUiEvent
    extends IsisApplibModule.TitleUiEvent<DomainObjectList> {
    }
}

