/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.conmap;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.conmap.ContentMappingService;
import org.apache.isis.applib.conmap.ContentMappingServiceForCommandDto;
import org.apache.isis.applib.services.metamodel.MetaModelService5;
import org.apache.isis.schema.cmd.v1.CommandDto;
import org.apache.isis.schema.cmd.v1.CommandsDto;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483647")
public class ContentMappingServiceForCommandsDto
implements ContentMappingService {
    @Inject
    MetaModelService5 metaModelService5;
    @Inject
    ContentMappingServiceForCommandDto contentMappingServiceForCommandDto;

    @Override
    @Programmatic
    public Object map(Object object, List<MediaType> acceptableMediaTypes) {
        boolean supported = ContentMappingService.Util.isSupported(CommandsDto.class, acceptableMediaTypes);
        if (!supported) {
            return null;
        }
        return this.map(object);
    }

    @Programmatic
    public CommandsDto map(Object object) {
        if (object instanceof CommandsDto) {
            return (CommandsDto)object;
        }
        CommandDto commandDto = this.asDto(object, this.metaModelService5);
        if (commandDto != null) {
            CommandsDto commandsDto = new CommandsDto();
            commandsDto.getCommandDto().add(commandDto);
            return commandsDto;
        }
        if (object instanceof List) {
            List list = (List)object;
            CommandsDto commandsDto = new CommandsDto();
            for (Object obj : list) {
                CommandDto objAsCommandDto = this.asDto(obj, this.metaModelService5);
                if (objAsCommandDto == null) continue;
                commandsDto.getCommandDto().add(objAsCommandDto);
            }
            return commandsDto;
        }
        return new CommandsDto();
    }

    private CommandDto asDto(Object object, MetaModelService5 metaModelService5) {
        return this.contentMappingServiceForCommandDto.asProcessedDto(object);
    }
}

