/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.conmap;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.isis.applib.annotation.Programmatic;

public interface ContentMappingService {
    @Programmatic
    public Object map(Object var1, List<MediaType> var2);

    public static class Util {
        public static String determineDomainType(List<MediaType> acceptableMediaTypes) {
            for (MediaType acceptableMediaType : acceptableMediaTypes) {
                Map parameters = acceptableMediaType.getParameters();
                String domainType = (String)parameters.get("x-ro-domain-type");
                if (domainType == null) continue;
                return domainType;
            }
            throw new IllegalArgumentException("Could not locate x-ro-domain-type parameter in any of the provided media types; got: " + Joiner.on((String)", ").join(acceptableMediaTypes));
        }

        public static boolean isSupported(Class<?> clazz, List<MediaType> acceptableMediaTypes) {
            String domainType = Util.determineDomainType(acceptableMediaTypes);
            return clazz.getName().equals(domainType);
        }
    }
}

