/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib.annotation;

import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.util.Enums;

public enum SemanticsOf {
    SAFE_AND_REQUEST_CACHEABLE,
    SAFE,
    IDEMPOTENT,
    NON_IDEMPOTENT,
    IDEMPOTENT_ARE_YOU_SURE,
    NON_IDEMPOTENT_ARE_YOU_SURE;


    public String getFriendlyName() {
        return Enums.getFriendlyNameOf(this);
    }

    public String getCamelCaseName() {
        return Enums.enumToCamelCase(this);
    }

    public boolean isIdempotentInNature() {
        return this.isSafeInNature() || this == IDEMPOTENT || this == IDEMPOTENT_ARE_YOU_SURE;
    }

    public boolean isSafeInNature() {
        return this.isSafeAndRequestCacheable() || this == SAFE;
    }

    @Deprecated
    public boolean isSafe() {
        return this.isSafeInNature();
    }

    public boolean isSafeAndRequestCacheable() {
        return this == SAFE_AND_REQUEST_CACHEABLE;
    }

    public boolean isAreYouSure() {
        return this == IDEMPOTENT_ARE_YOU_SURE || this == NON_IDEMPOTENT_ARE_YOU_SURE;
    }

    @Deprecated
    public static ActionSemantics.Of from(SemanticsOf semantics) {
        if (semantics == null) {
            return null;
        }
        if (semantics == SAFE_AND_REQUEST_CACHEABLE) {
            return ActionSemantics.Of.SAFE_AND_REQUEST_CACHEABLE;
        }
        if (semantics == SAFE) {
            return ActionSemantics.Of.SAFE;
        }
        if (semantics == IDEMPOTENT) {
            return ActionSemantics.Of.IDEMPOTENT;
        }
        if (semantics == IDEMPOTENT_ARE_YOU_SURE) {
            return ActionSemantics.Of.IDEMPOTENT_ARE_YOU_SURE;
        }
        if (semantics == NON_IDEMPOTENT) {
            return ActionSemantics.Of.NON_IDEMPOTENT;
        }
        if (semantics == NON_IDEMPOTENT_ARE_YOU_SURE) {
            return ActionSemantics.Of.NON_IDEMPOTENT_ARE_YOU_SURE;
        }
        throw new IllegalArgumentException("Unrecognized of: " + (Object)((Object)semantics));
    }

    @Deprecated
    public static SemanticsOf from(ActionSemantics.Of semantics) {
        if (semantics == null) {
            return null;
        }
        if (semantics == ActionSemantics.Of.SAFE_AND_REQUEST_CACHEABLE) {
            return SAFE_AND_REQUEST_CACHEABLE;
        }
        if (semantics == ActionSemantics.Of.SAFE) {
            return SAFE;
        }
        if (semantics == ActionSemantics.Of.IDEMPOTENT) {
            return IDEMPOTENT;
        }
        if (semantics == ActionSemantics.Of.IDEMPOTENT_ARE_YOU_SURE) {
            return IDEMPOTENT_ARE_YOU_SURE;
        }
        if (semantics == ActionSemantics.Of.NON_IDEMPOTENT) {
            return NON_IDEMPOTENT;
        }
        if (semantics == ActionSemantics.Of.NON_IDEMPOTENT_ARE_YOU_SURE) {
            return NON_IDEMPOTENT_ARE_YOU_SURE;
        }
        throw new IllegalArgumentException("Unrecognized semantics: " + (Object)((Object)semantics));
    }
}

