/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.List;
import org.apache.isis.applib.services.exceprecog.TranslatableException;
import org.apache.isis.applib.services.i18n.TranslatableString;

public class RecoverableException
extends RuntimeException
implements TranslatableException {
    private static final long serialVersionUID = 1L;
    private final TranslatableString translatableMessage;
    private final String translationContext;

    public RecoverableException(String msg) {
        this(msg, null, null, null, null);
    }

    public RecoverableException(TranslatableString translatableMessage, Class<?> translationContextClass, String translationContextMethod) {
        this(null, translatableMessage, translationContextClass, translationContextMethod, null);
    }

    public RecoverableException(Throwable cause) {
        this(null, null, null, null, cause);
    }

    public RecoverableException(String msg, Throwable cause) {
        this(msg, null, null, null, cause);
    }

    public RecoverableException(TranslatableString translatableMessage, Class<?> translationContextClass, String translationContextMethod, Throwable cause) {
        this(null, translatableMessage, translationContextClass, translationContextMethod, cause);
    }

    private RecoverableException(String message, TranslatableString translatableMessage, Class<?> translationContextClass, String translationContextMethod, Throwable cause) {
        super(message, cause);
        this.translatableMessage = translatableMessage;
        this.translationContext = translationContextClass != null ? translationContextClass.getName() + (!Strings.isNullOrEmpty((String)translationContextMethod) ? "#" + translationContextMethod : "") : null;
    }

    @Override
    public String getMessage() {
        return this.getTranslatableMessage() != null ? this.getTranslatableMessage().getPattern() : super.getMessage();
    }

    @Override
    public TranslatableString getTranslatableMessage() {
        return this.translatableMessage;
    }

    @Override
    public String getTranslationContext() {
        return this.translationContext;
    }

    public static class Util {
        private Util() {
        }

        public static RecoverableException getRecoverableExceptionIfAny(Exception ex) {
            List causalChain = Throwables.getCausalChain((Throwable)ex);
            Iterable appEx = Iterables.filter((Iterable)causalChain, RecoverableException.class);
            Iterator iterator = appEx.iterator();
            return iterator.hasNext() ? (RecoverableException)iterator.next() : null;
        }
    }
}

