/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class PropertyResource {
    private final Class<?> propertiesFileContext;
    private final String propertiesFile;

    PropertyResource(Class<?> propertiesFileContext, String propertiesFile) {
        this.propertiesFileContext = propertiesFileContext;
        this.propertiesFile = propertiesFile;
    }

    Class<?> getPropertiesFileContext() {
        return this.propertiesFileContext;
    }

    String getPropertiesFile() {
        return this.propertiesFile;
    }

    void loadPropsInto(Map<String, String> props) {
        Properties properties = new Properties();
        try (InputStream stream = this.propertiesFileContext.getResourceAsStream(this.propertiesFile);){
            properties.load(stream);
            for (Object key : properties.keySet()) {
                Object value = properties.get(key);
                if (!(key instanceof String) || !(value instanceof String)) continue;
                props.put((String)key, (String)value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to load '%s' file relative to %s", this.getPropertiesFile(), this.getPropertiesFileContext().getName()), e);
        }
    }
}

