/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.isis.applib.Module;
import org.apache.isis.applib.PropertyResource;

abstract class ModuleOrBuilderAbstract<B extends ModuleOrBuilderAbstract> {
    final Set<Class<?>> additionalModules = Sets.newLinkedHashSet();
    final Set<Class<?>> additionalServices = Sets.newLinkedHashSet();
    final Map<String, String> individualConfigProps = Maps.newLinkedHashMap();
    final List<PropertyResource> propertyResources = Lists.newArrayList();

    ModuleOrBuilderAbstract() {
    }

    public B withAdditionalDependency(Module dependency) {
        this.withTransitiveFrom(dependency);
        return (B)this;
    }

    public B withAdditionalDependencies(Set<Module> dependencies) {
        for (Module dependency : dependencies) {
            this.withAdditionalDependency(dependency);
        }
        return (B)this;
    }

    public B withAdditionalDependencies(Module ... dependencies) {
        return this.withAdditionalDependencies(Sets.newHashSet((Object[])dependencies));
    }

    void withTransitiveFrom(Module module) {
        this.withAdditionalModules(ModuleOrBuilderAbstract.asClasses(Module.Util.transitiveDependenciesOf(module)));
        this.withAdditionalModules(Module.Util.transitiveAdditionalModulesOf(module));
        this.withAdditionalServices(Module.Util.transitiveAdditionalServicesOf(module));
        this.withConfigurationPropertyResources(Module.Util.transitivePropertyResourcesOf(module));
        this.withConfigurationProperties(Module.Util.transitiveIndividualConfigPropsOf(module));
    }

    private static Class[] asClasses(List<Module> dependencies) {
        ArrayList list = new ArrayList();
        for (Module dependency : dependencies) {
            Class<?> aClass = dependency.getClass();
            list.add(aClass);
        }
        return list.toArray(new Class[0]);
    }

    public B withAdditionalModules(Class<?> ... modules) {
        return this.withAdditionalModules(Arrays.asList(modules));
    }

    public B withAdditionalModules(List<Class<?>> modules) {
        if (modules == null) {
            return (B)this;
        }
        this.additionalModules.addAll(modules);
        return (B)this;
    }

    public B withAdditionalServices(Class<?> ... additionalServices) {
        return this.withAdditionalServices(Arrays.asList(additionalServices));
    }

    public B withAdditionalServices(List<Class<?>> additionalServices) {
        if (additionalServices == null) {
            return (B)this;
        }
        this.additionalServices.addAll(additionalServices);
        return (B)this;
    }

    public B withConfigurationProperties(Map<String, String> configurationProperties) {
        for (Map.Entry<String, String> keyValue : configurationProperties.entrySet()) {
            this.withConfigurationProperty(keyValue.getKey(), keyValue.getValue());
        }
        return (B)this;
    }

    public B withConfigurationPropertiesFile(String propertiesFile) {
        return this.withConfigurationPropertiesFile(this.getClass(), propertiesFile, new String[0]);
    }

    public B withConfigurationPropertyResources(List<PropertyResource> propertyResources) {
        for (PropertyResource propertyResource : propertyResources) {
            this.withConfigurationPropertyResource(propertyResource);
        }
        return (B)this;
    }

    public B withConfigurationPropertyResource(PropertyResource propertyResource) {
        this.addPropertyResource(propertyResource);
        return (B)this;
    }

    public B withConfigurationPropertiesFile(Class<?> propertiesFileContext, String propertiesFile, String ... furtherPropertiesFiles) {
        this.addPropertyResource(propertiesFileContext, propertiesFile);
        for (String otherFile : furtherPropertiesFiles) {
            this.addPropertyResource(propertiesFileContext, otherFile);
        }
        return (B)this;
    }

    private void addPropertyResource(Class<?> propertiesFileContext, String propertiesFile) {
        this.addPropertyResource(new PropertyResource(propertiesFileContext, propertiesFile));
    }

    private void addPropertyResource(PropertyResource propertyResource) {
        this.propertyResources.add(propertyResource);
    }

    public B withConfigurationProperty(String key, String value) {
        this.individualConfigProps.put(key, value);
        return (B)this;
    }

    public B withConfigurationProperty(Map.Entry<String, String> keyValue) {
        return this.withConfigurationProperty(keyValue.getKey(), keyValue.getValue());
    }

    @XmlTransient
    public Map<String, String> getIndividualConfigProps() {
        return this.individualConfigProps;
    }

    @XmlTransient
    public List<PropertyResource> getPropertyResources() {
        return this.propertyResources;
    }
}

