/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.isis.applib.Module;
import org.apache.isis.applib.ModuleOrBuilderAbstract;
import org.apache.isis.applib.fixturescripts.FixtureScript;

public abstract class ModuleAbstract
extends ModuleOrBuilderAbstract<ModuleAbstract>
implements Module {
    @Override
    @XmlTransient
    public Set<Module> getDependencies() {
        return Sets.newLinkedHashSet();
    }

    @XmlElement(name="module", required=true)
    private Set<ModuleAbstract> getModuleDependencies() {
        return FluentIterable.from(this.getDependencies()).filter((Predicate)new Predicate<Module>(){

            public boolean apply(@Nullable Module module) {
                return module instanceof ModuleAbstract;
            }
        }).transform((Function)new Function<Module, ModuleAbstract>(){

            @Nullable
            public ModuleAbstract apply(@Nullable Module module) {
                return (ModuleAbstract)module;
            }
        }).toSet();
    }

    @Override
    @XmlTransient
    public Set<Class<?>> getAdditionalModules() {
        return this.additionalModules;
    }

    @Override
    @XmlTransient
    public FixtureScript getRefDataSetupFixture() {
        return null;
    }

    @Override
    @XmlTransient
    public FixtureScript getTeardownFixture() {
        return null;
    }

    @Override
    @XmlTransient
    public Set<Class<?>> getAdditionalServices() {
        return this.additionalServices;
    }

    @XmlAttribute(required=true)
    public String getName() {
        return this.getClass().getSimpleName();
    }

    private String getFullName() {
        return this.getClass().getName();
    }

    public String toString() {
        return this.getFullName();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleAbstract)) {
            return false;
        }
        ModuleAbstract other = (ModuleAbstract)o;
        return Objects.equals(this.getFullName(), other.getFullName());
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }
}

