/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.isis.applib.PropertyResource;
import org.apache.isis.applib.fixturescripts.FixtureScript;

public interface Module {
    public Set<Module> getDependencies();

    public Set<Class<?>> getAdditionalModules();

    public FixtureScript getRefDataSetupFixture();

    public FixtureScript getTeardownFixture();

    public Set<Class<?>> getAdditionalServices();

    public Map<String, String> getIndividualConfigProps();

    public List<PropertyResource> getPropertyResources();

    public static class Util {
        private Util() {
        }

        static List<Module> transitiveDependenciesOf(Module module) {
            ArrayList ordered = Lists.newArrayList();
            ArrayList visited = Lists.newArrayList();
            Util.appendDependenciesTo(ordered, module, visited);
            LinkedHashSet sequencedSet = Sets.newLinkedHashSet((Iterable)ordered);
            return Lists.newArrayList((Iterable)sequencedSet);
        }

        static List<Class<?>> transitiveAdditionalModulesOf(Module module) {
            HashSet modules = Sets.newHashSet();
            List<Module> transitiveDependencies = Util.transitiveDependenciesOf(module);
            for (Module transitiveDependency : transitiveDependencies) {
                Set<Class<?>> additionalModules = transitiveDependency.getAdditionalModules();
                if (additionalModules == null || additionalModules.isEmpty()) continue;
                for (Class<?> clazz : additionalModules) {
                    if (!Module.class.isAssignableFrom(clazz)) continue;
                    throw new IllegalArgumentException("Module " + transitiveDependency + " has returned " + clazz + " from getAdditionalModules().  This class implements 'Module' interface so should instead be returned from getDependencies()");
                }
                modules.addAll(additionalModules);
            }
            return Lists.newArrayList((Iterable)modules);
        }

        static List<Class<?>> transitiveAdditionalServicesOf(Module module) {
            HashSet services = Sets.newHashSet();
            List<Module> transitiveDependencies = Util.transitiveDependenciesOf(module);
            for (Module transitiveDependency : transitiveDependencies) {
                Set<Class<?>> additionalServices = transitiveDependency.getAdditionalServices();
                if (additionalServices == null || additionalServices.isEmpty()) continue;
                services.addAll(additionalServices);
            }
            return Lists.newArrayList((Iterable)services);
        }

        private static void appendDependenciesTo(List<Module> ordered, Module module, List<Module> visited) {
            if (visited.contains(module)) {
                throw new IllegalStateException(String.format("Cyclic dependency detected; visited: %s", visited));
            }
            visited.add(module);
            Set<Module> dependencies = module.getDependencies();
            if (dependencies.isEmpty() || ordered.containsAll(dependencies)) {
                ordered.add(module);
                visited.clear();
            } else {
                for (Module dependency : dependencies) {
                    Util.appendDependenciesTo(ordered, dependency, visited);
                }
            }
            if (!ordered.contains(module)) {
                ordered.add(module);
            }
        }

        static Map<String, String> transitiveIndividualConfigPropsOf(Module module) {
            LinkedHashMap transitiveIndividualConfigProps = Maps.newLinkedHashMap();
            List<Module> transitiveDependencies = Util.transitiveDependenciesOf(module);
            for (Module transitiveDependency : transitiveDependencies) {
                transitiveIndividualConfigProps.putAll(transitiveDependency.getIndividualConfigProps());
            }
            return transitiveIndividualConfigProps;
        }

        static List<PropertyResource> transitivePropertyResourcesOf(Module module) {
            ArrayList transitivePropertyResources = Lists.newArrayList();
            List<Module> transitiveDependencies = Util.transitiveDependenciesOf(module);
            for (Module transitiveDependency : transitiveDependencies) {
                transitivePropertyResources.addAll(transitiveDependency.getPropertyResources());
            }
            return transitivePropertyResources;
        }
    }
}

