/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.AppManifest2;
import org.apache.isis.applib.AppManifestAbstract;
import org.apache.isis.applib.Module;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.fixturescripts.FixtureScript;

public abstract class AppManifestAbstract2
extends AppManifestAbstract
implements AppManifest2 {
    private final Module module;

    public AppManifestAbstract2(Builder builder) {
        super(builder);
        this.module = builder.getModule();
    }

    @Override
    @Programmatic
    public Module getModule() {
        return this.module;
    }

    @Override
    @Programmatic
    public FixtureScript getRefDataSetupFixture() {
        return new FixtureScript(){

            @Override
            protected void execute(FixtureScript.ExecutionContext executionContext) {
                List<Module> modules = Module.Util.transitiveDependenciesOf(AppManifestAbstract2.this.module);
                for (Module module : modules) {
                    FixtureScript fixtureScript = module.getRefDataSetupFixture();
                    if (fixtureScript == null) continue;
                    executionContext.executeChild((FixtureScript)this, fixtureScript);
                }
            }
        };
    }

    @Override
    @Programmatic
    public FixtureScript getTeardownFixture() {
        return new FixtureScript(){

            @Override
            protected void execute(FixtureScript.ExecutionContext executionContext) {
                List<Module> modules = Module.Util.transitiveDependenciesOf(AppManifestAbstract2.this.module);
                Collections.reverse(modules);
                for (Module module : modules) {
                    FixtureScript fixtureScript = module.getTeardownFixture();
                    if (fixtureScript == null) continue;
                    executionContext.executeChild((FixtureScript)this, fixtureScript);
                }
            }
        };
    }

    public static class Builder
    extends AppManifestAbstract.BuilderAbstract<Builder> {
        private final Module module;

        public static Builder forModule(Module module) {
            return new Builder(module);
        }

        private Builder(Module module) {
            this.module = module;
            this.withTransitiveFrom(module);
        }

        public Module getModule() {
            return this.module;
        }

        @Override
        public AppManifest2 build() {
            return new Default(this);
        }
    }

    public static class Default
    extends AppManifestAbstract2 {
        public Default(Builder builder) {
            super(builder);
        }
    }
}

