/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.applib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.AppManifestAbstract2;
import org.apache.isis.applib.ModuleOrBuilderAbstract;
import org.apache.isis.applib.PropertyResource;
import org.apache.isis.applib.fixturescripts.FixtureScript;

public abstract class AppManifestAbstract
implements AppManifest {
    private final List<Class<?>> modules;
    private final List<Class<?>> additionalServices;
    private final String authMechanism;
    private final List<Class<? extends FixtureScript>> fixtureClasses;
    private final Map<String, String> configurationProperties;

    public AppManifestAbstract(BuilderAbstract<?> builder) {
        List<Class<?>> builderModules = builder.getAllAdditionalModules();
        this.overrideModules(builderModules);
        this.modules = builderModules;
        ArrayList builderAdditionalServices = Lists.newArrayList(builder.getAllAdditionalServices());
        this.overrideAdditionalServices(builderAdditionalServices);
        this.additionalServices = builderAdditionalServices;
        this.authMechanism = this.determineAuthMechanism(builder);
        this.fixtureClasses = this.determineFixtures(builder);
        this.configurationProperties = this.createConfigurationProperties(builder.getAllPropertyResources(), builder.getAllIndividualConfigProps(), this.fixtureClasses);
    }

    private String determineAuthMechanism(ModuleOrBuilderAbstract<?> builder) {
        String overriddenAuthMechanism = this.overrideAuthMechanism();
        if (overriddenAuthMechanism != null) {
            return overriddenAuthMechanism;
        }
        return AppManifestAbstract.obtainAuthMechanismFrom(builder);
    }

    private List<Class<? extends FixtureScript>> determineFixtures(ModuleOrBuilderAbstract<?> builder) {
        List<Class<? extends FixtureScript>> builderFixtures = AppManifestAbstract.obtainBuilderFixturesFrom(builder);
        this.overrideFixtures(builderFixtures);
        return builderFixtures;
    }

    private static String obtainAuthMechanismFrom(ModuleOrBuilderAbstract<?> builder) {
        if (builder instanceof Builder) {
            return ((Builder)builder).authMechanism;
        }
        if (builder instanceof AppManifestAbstract2.Builder) {
            return ((AppManifestAbstract2.Builder)builder).authMechanism;
        }
        return null;
    }

    private static List<Class<? extends FixtureScript>> obtainBuilderFixturesFrom(ModuleOrBuilderAbstract<?> builder) {
        if (builder instanceof Builder) {
            return ((Builder)builder).fixtures;
        }
        if (builder instanceof AppManifestAbstract2.Builder) {
            return ((AppManifestAbstract2.Builder)builder).fixtures;
        }
        return Lists.newArrayList();
    }

    private Map<String, String> createConfigurationProperties(List<PropertyResource> propertyResources, Map<String, String> individualConfigProps, List<Class<? extends FixtureScript>> fixtures) {
        HashMap props = Maps.newHashMap();
        for (PropertyResource propertyResource : propertyResources) {
            propertyResource.loadPropsInto(props);
        }
        for (Map.Entry entry : individualConfigProps.entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
        if (!fixtures.isEmpty()) {
            props.put("isis.persistor.datanucleus.install-fixtures", "true");
        }
        this.overrideConfigurationProperties(props);
        return props;
    }

    @Override
    public final List<Class<?>> getModules() {
        return this.modules;
    }

    protected void overrideModules(List<Class<?>> modules) {
    }

    @Override
    public final List<Class<?>> getAdditionalServices() {
        return this.additionalServices;
    }

    protected void overrideAdditionalServices(List<Class<?>> additionalServices) {
    }

    @Override
    public final String getAuthenticationMechanism() {
        return this.authMechanism;
    }

    protected String overrideAuthMechanism() {
        return null;
    }

    @Override
    public final String getAuthorizationMechanism() {
        return this.authMechanism;
    }

    @Override
    public final List<Class<? extends FixtureScript>> getFixtures() {
        return this.fixtureClasses;
    }

    protected void overrideFixtures(List<Class<? extends FixtureScript>> fixtureScriptClasses) {
    }

    @Override
    public final Map<String, String> getConfigurationProperties() {
        return this.configurationProperties;
    }

    protected void overrideConfigurationProperties(Map<String, String> configurationProperties) {
    }

    public static class Builder
    extends BuilderAbstract<Builder> {
        public static Builder forModules(List<Class<?>> modules) {
            return (Builder)new Builder().withAdditionalModules(modules);
        }

        public static Builder forModules(Class<?> ... modules) {
            return Builder.forModules(Arrays.asList(modules));
        }

        @Override
        public AppManifest build() {
            return new Default(this);
        }
    }

    public static abstract class BuilderAbstract<B extends BuilderAbstract<B>>
    extends ModuleOrBuilderAbstract<B> {
        String authMechanism = "shiro";
        List<Class<? extends FixtureScript>> fixtures = Lists.newArrayList();

        public B withAuthMechanism(String authMechanism) {
            this.authMechanism = authMechanism;
            return (B)this;
        }

        public B withFixtureScripts(Class<? extends FixtureScript> ... fixtures) {
            return this.withFixtureScripts(Arrays.asList(fixtures));
        }

        public B withFixtureScripts(List<Class<? extends FixtureScript>> fixtures) {
            if (fixtures == null) {
                return (B)this;
            }
            this.fixtures.addAll(fixtures);
            return (B)this;
        }

        List<Class<?>> getAllAdditionalModules() {
            return Lists.newArrayList((Iterable)this.additionalModules);
        }

        Set<Class<?>> getAllAdditionalServices() {
            return this.additionalServices;
        }

        List<PropertyResource> getAllPropertyResources() {
            return this.getPropertyResources();
        }

        Map<String, String> getAllIndividualConfigProps() {
            return this.getIndividualConfigProps();
        }

        public abstract AppManifest build();
    }

    public static class Default
    extends AppManifestAbstract {
        public Default(Builder builder) {
            super(builder);
        }
    }
}

