/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.CacheControl;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.util.PathNode;

public abstract class Parser<T> {
    public T valueOf(List<String> str) {
        if (str == null) {
            return null;
        }
        if (str.size() == 0) {
            return null;
        }
        return this.valueOf(str.get(0));
    }

    public T valueOf(String[] str) {
        if (str == null) {
            return null;
        }
        if (str.length == 0) {
            return null;
        }
        return this.valueOf(str[0]);
    }

    public T valueOf(JsonRepresentation jsonRepresentation) {
        if (jsonRepresentation == null) {
            return null;
        }
        return this.valueOf(jsonRepresentation.asString());
    }

    public JsonRepresentation asJsonRepresentation(T t) {
        return JsonRepresentation.newMap("dummy", this.asString(t)).getRepresentation("dummy", new Object[0]);
    }

    public abstract T valueOf(String var1);

    public abstract String asString(T var1);

    public static final Parser<String> forString() {
        return new Parser<String>(){

            @Override
            public String valueOf(String str) {
                return str;
            }

            @Override
            public String asString(String t) {
                return t;
            }
        };
    }

    public static Parser<Date> forDate() {
        return new Parser<Date>(){
            private final SimpleDateFormat RFC1123_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z");

            @Override
            public Date valueOf(String str) {
                if (str == null) {
                    return null;
                }
                try {
                    return this.RFC1123_DATE_FORMAT.parse(str);
                }
                catch (ParseException e) {
                    return null;
                }
            }

            @Override
            public String asString(Date t) {
                return this.RFC1123_DATE_FORMAT.format(t);
            }
        };
    }

    public static Parser<CacheControl> forCacheControl() {
        return new Parser<CacheControl>(){

            @Override
            public CacheControl valueOf(String str) {
                if (str == null) {
                    return null;
                }
                CacheControl cacheControl = CacheControl.valueOf((String)str);
                cacheControl.getCacheExtension();
                cacheControl.getNoCacheFields();
                return cacheControl;
            }

            @Override
            public String asString(CacheControl cacheControl) {
                return cacheControl.toString();
            }
        };
    }

    public static Parser<javax.ws.rs.core.MediaType> forJaxRsMediaType() {
        return new Parser<javax.ws.rs.core.MediaType>(){

            @Override
            public javax.ws.rs.core.MediaType valueOf(String str) {
                if (str == null) {
                    return null;
                }
                return javax.ws.rs.core.MediaType.valueOf((String)str);
            }

            @Override
            public String asString(javax.ws.rs.core.MediaType t) {
                return t.toString();
            }
        };
    }

    public static Parser<MediaType> forGuavaMediaType() {
        return new Parser<MediaType>(){

            @Override
            public MediaType valueOf(String str) {
                if (str == null) {
                    return null;
                }
                return MediaType.parse((String)str);
            }

            @Override
            public String asString(MediaType t) {
                return t.toString();
            }
        };
    }

    public static Parser<Boolean> forBoolean() {
        return new Parser<Boolean>(){

            @Override
            public Boolean valueOf(String str) {
                if (str == null) {
                    return null;
                }
                return "yes".equalsIgnoreCase(str) || "true".equalsIgnoreCase(str) ? Boolean.TRUE : Boolean.FALSE;
            }

            @Override
            public String asString(Boolean t) {
                return t != false ? "yes" : "no";
            }
        };
    }

    public static Parser<Integer> forInteger() {
        return new Parser<Integer>(){

            @Override
            public Integer valueOf(String str) {
                if (str == null) {
                    return null;
                }
                return Integer.valueOf(str);
            }

            @Override
            public String asString(Integer t) {
                return t.toString();
            }
        };
    }

    public static Parser<List<String>> forListOfStrings() {
        return new Parser<List<String>>(){

            @Override
            public List<String> valueOf(List<String> strings) {
                if (strings == null) {
                    return Collections.emptyList();
                }
                if (strings.size() == 1) {
                    return this.valueOf(strings.get(0));
                }
                return strings;
            }

            @Override
            public List<String> valueOf(String[] strings) {
                if (strings == null) {
                    return Collections.emptyList();
                }
                if (strings.length == 1) {
                    return this.valueOf(strings[0]);
                }
                return Arrays.asList(strings);
            }

            @Override
            public List<String> valueOf(String str) {
                if (str == null) {
                    return Collections.emptyList();
                }
                return Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)str));
            }

            @Override
            public String asString(List<String> strings) {
                return Joiner.on((String)",").join(strings);
            }
        };
    }

    public static Parser<List<List<String>>> forListOfListOfStrings() {
        return new Parser<List<List<String>>>(){

            @Override
            public List<List<String>> valueOf(List<String> str) {
                if (str == null) {
                    return null;
                }
                if (str.size() == 0) {
                    return null;
                }
                ArrayList listOfLists = Lists.newArrayList();
                for (String s : str) {
                    listOfLists.add(PathNode.split(s));
                }
                return listOfLists;
            }

            @Override
            public List<List<String>> valueOf(String[] str) {
                if (str == null) {
                    return null;
                }
                if (str.length == 0) {
                    return null;
                }
                return this.valueOf((List)Arrays.asList(str));
            }

            @Override
            public List<List<String>> valueOf(String str) {
                if (str == null || str.isEmpty()) {
                    return Collections.emptyList();
                }
                Iterable listOfStrings = Splitter.on((char)',').split((CharSequence)str);
                return Lists.transform((List)Lists.newArrayList((Iterable)listOfStrings), (Function)new Function<String, List<String>>(){

                    public List<String> apply(String input) {
                        return PathNode.split(input);
                    }
                });
            }

            @Override
            public String asString(List<List<String>> listOfLists) {
                List listOfStrings = Lists.transform(listOfLists, (Function)new Function<List<String>, String>(){

                    public String apply(List<String> listOfStrings) {
                        return Joiner.on((char)'.').join(listOfStrings);
                    }
                });
                return Joiner.on((char)',').join((Iterable)listOfStrings);
            }
        };
    }

    public static Parser<String[]> forArrayOfStrings() {
        return new Parser<String[]>(){

            @Override
            public String[] valueOf(List<String> strings) {
                if (strings == null) {
                    return new String[0];
                }
                if (strings.size() == 1) {
                    return this.valueOf(strings.get(0));
                }
                return strings.toArray(new String[0]);
            }

            @Override
            public String[] valueOf(String[] strings) {
                if (strings == null) {
                    return new String[0];
                }
                if (strings.length == 1) {
                    return this.valueOf(strings[0]);
                }
                return strings;
            }

            @Override
            public String[] valueOf(String str) {
                if (str == null) {
                    return new String[0];
                }
                Iterable split = Splitter.on((String)",").split((CharSequence)str);
                return (String[])Iterables.toArray((Iterable)split, String.class);
            }

            @Override
            public String asString(String[] strings) {
                return Joiner.on((String)",").join((Object[])strings);
            }
        };
    }

    public static Parser<List<javax.ws.rs.core.MediaType>> forListOfJaxRsMediaTypes() {
        return new Parser<List<javax.ws.rs.core.MediaType>>(){

            @Override
            public List<javax.ws.rs.core.MediaType> valueOf(String str) {
                if (str == null) {
                    return Collections.emptyList();
                }
                ArrayList strings = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)str));
                return Lists.transform((List)strings, (Function)new Function<String, javax.ws.rs.core.MediaType>(){

                    public javax.ws.rs.core.MediaType apply(String input) {
                        return javax.ws.rs.core.MediaType.valueOf((String)input);
                    }
                });
            }

            @Override
            public String asString(List<javax.ws.rs.core.MediaType> listOfMediaTypes) {
                List strings = Lists.transform(listOfMediaTypes, (Function)new Function<javax.ws.rs.core.MediaType, String>(){

                    public String apply(javax.ws.rs.core.MediaType input) {
                        return input.toString();
                    }
                });
                return Joiner.on((String)",").join((Iterable)strings);
            }
        };
    }

    public static Parser<List<MediaType>> forListOfGuavaMediaTypes() {
        return new Parser<List<MediaType>>(){

            @Override
            public List<MediaType> valueOf(String str) {
                if (str == null) {
                    return Collections.emptyList();
                }
                ArrayList strings = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)str));
                return Lists.transform((List)strings, (Function)new Function<String, MediaType>(){

                    public MediaType apply(String input) {
                        return MediaType.parse((String)input);
                    }
                });
            }

            @Override
            public String asString(List<MediaType> listOfMediaTypes) {
                List strings = Lists.transform(listOfMediaTypes, (Function)new Function<MediaType, String>(){

                    public String apply(MediaType input) {
                        return input.toString();
                    }
                });
                return Joiner.on((String)",").join((Iterable)strings);
            }
        };
    }

    public static Parser<String> forETag() {
        return new Parser<String>(){
            private static final String WEAK_PREFIX = "W/";

            @Override
            public String valueOf(String str) {
                if (str == null) {
                    return null;
                }
                return null;
            }

            @Override
            public String asString(String t) {
                return null;
            }
        };
    }
}

