/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.restfulobjects.applib;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.isis.applib.util.Enums;
import org.apache.isis.viewer.restfulobjects.applib.JsonRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.DomainObjectRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ListRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ObjectActionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ObjectCollectionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domainobjects.ObjectPropertyRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.ActionDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.ActionParameterDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.CollectionDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.DomainTypeRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.PropertyDescriptionRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.TypeActionResultRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.domaintypes.TypeListRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.errors.ErrorRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.health.HealthRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.homepage.HomePageRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.user.UserRepresentation;
import org.apache.isis.viewer.restfulobjects.applib.util.Parser;
import org.apache.isis.viewer.restfulobjects.applib.version.VersionRepresentation;

public enum RepresentationType {
    HOME_PAGE("application/json;profile=urn:org.restfulobjects:repr-types/homepage", null, HomePageRepresentation.class),
    USER("application/json;profile=urn:org.restfulobjects:repr-types/user", null, UserRepresentation.class),
    VERSION("application/json;profile=urn:org.restfulobjects:repr-types/version", null, VersionRepresentation.class),
    HEALTH("application/json;profile=urn:org.restfulobjects:repr-types/health", null, HealthRepresentation.class),
    LIST("application/json;profile=urn:org.restfulobjects:repr-types/list", null, ListRepresentation.class),
    DOMAIN_OBJECT("application/json;profile=urn:org.restfulobjects:repr-types/object", "application/xml;profile=urn:org.restfulobjects:repr-types/object", DomainObjectRepresentation.class),
    OBJECT_PROPERTY("application/json;profile=urn:org.restfulobjects:repr-types/object-property", "application/xml;profile=urn:org.restfulobjects:repr-types/object-property", ObjectPropertyRepresentation.class),
    OBJECT_COLLECTION("application/json;profile=urn:org.restfulobjects:repr-types/object-collection", "application/xml;profile=urn:org.restfulobjects:repr-types/object-collection", ObjectCollectionRepresentation.class),
    OBJECT_ACTION("application/json;profile=urn:org.restfulobjects:repr-types/object-action", "application/xml;profile=urn:org.restfulobjects:repr-types/object-action", ObjectActionRepresentation.class),
    ACTION_RESULT("application/json;profile=urn:org.restfulobjects:repr-types/action-result", "application/xml;profile=urn:org.restfulobjects:repr-types/action-result", ActionResultRepresentation.class),
    TYPE_LIST("application/json;profile=urn:org.restfulobjects:repr-types/type-list", null, TypeListRepresentation.class),
    DOMAIN_TYPE("application/json;profile=urn:org.restfulobjects:repr-types/domain-type", null, DomainTypeRepresentation.class),
    LAYOUT("application/json;profile=urn:org.restfulobjects:repr-types/layout-bs3", "application/xml;profile=urn:org.restfulobjects:repr-types/layout-bs3", null),
    OBJECT_LAYOUT("application/json;profile=urn:org.restfulobjects:repr-types/object-layout-bs3", "application/xml;profile=urn:org.restfulobjects:repr-types/object-layout-bs3", null),
    OBJECT_IMAGE("image/png", "image/png", null),
    MENUBARS("application/json;profile=urn:org.restfulobjects:repr-types/layout-menubars", "application/xml;profile=urn:org.restfulobjects:repr-types/layout-menubars", null),
    PROPERTY_DESCRIPTION("application/json;profile=urn:org.restfulobjects:repr-types/property-description", null, PropertyDescriptionRepresentation.class),
    COLLECTION_DESCRIPTION("application/json;profile=urn:org.restfulobjects:repr-types/collection-description", null, CollectionDescriptionRepresentation.class),
    ACTION_DESCRIPTION("application/json;profile=urn:org.restfulobjects:repr-types/action-description", null, ActionDescriptionRepresentation.class),
    ACTION_PARAMETER_DESCRIPTION("application/json;profile=urn:org.restfulobjects:repr-types/action-param-description", null, ActionParameterDescriptionRepresentation.class),
    TYPE_ACTION_RESULT("application/json;profile=urn:org.restfulobjects:repr-types/type-action-result", null, TypeActionResultRepresentation.class),
    ERROR("application/json;profile=urn:org.restfulobjects:repr-types/error", "application/xml;profile=urn:org.restfulobjects:repr-types/error", ErrorRepresentation.class),
    GENERIC("application/json", "application/xml", JsonRepresentation.class);

    private final String name;
    private final MediaType jsonMediaType;
    private MediaType xmlMediaType;
    private final Class<? extends JsonRepresentation> representationClass;

    private RepresentationType(String jsonMediaTypeStr, String xmlMediaTypeStr, Class<? extends JsonRepresentation> representationClass) {
        this(jsonMediaTypeStr != null ? MediaType.valueOf((String)jsonMediaTypeStr) : null, xmlMediaTypeStr != null ? MediaType.valueOf((String)xmlMediaTypeStr) : null, representationClass);
    }

    private RepresentationType(MediaType jsonMediaType, MediaType xmlMediaType, Class<? extends JsonRepresentation> representationClass) {
        this.xmlMediaType = xmlMediaType;
        this.representationClass = representationClass;
        this.name = Enums.enumToCamelCase((Enum)this);
        this.jsonMediaType = jsonMediaType;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public final MediaType getMediaType() {
        return this.getJsonMediaType();
    }

    public final MediaType getJsonMediaType() {
        return this.jsonMediaType;
    }

    public MediaType getXmlMediaType() {
        return this.xmlMediaType;
    }

    public MediaType getJsonElseXmlMediaType() {
        return this.jsonMediaType != null ? this.jsonMediaType : this.xmlMediaType;
    }

    public MediaType getMediaType(String parameter, String paramValue) {
        return this.getMediaType(Collections.singletonMap(parameter, paramValue));
    }

    @Deprecated
    public MediaType getMediaType(Map<String, String> mediaTypeParams) {
        return this.getJsonMediaType(mediaTypeParams);
    }

    public MediaType getJsonMediaType(Map<String, String> mediaTypeParams) {
        HashMap parameters = Maps.newHashMap((Map)this.jsonMediaType.getParameters());
        parameters.putAll(mediaTypeParams);
        return new MediaType(this.jsonMediaType.getType(), this.jsonMediaType.getSubtype(), (Map)parameters);
    }

    public MediaType getXmlMediaType(Map<String, String> mediaTypeParams) {
        if (this.xmlMediaType == null) {
            return null;
        }
        HashMap parameters = Maps.newHashMap((Map)this.xmlMediaType.getParameters());
        parameters.putAll(mediaTypeParams);
        return new MediaType(this.xmlMediaType.getType(), this.xmlMediaType.getSubtype(), (Map)parameters);
    }

    public String getMediaTypeProfile() {
        return (String)this.getJsonMediaType().getParameters().get("profile");
    }

    public Class<? extends JsonRepresentation> getRepresentationClass() {
        return this.representationClass;
    }

    public static RepresentationType lookup(String name) {
        for (RepresentationType representationType : RepresentationType.values()) {
            if (!representationType.getName().equals(name)) continue;
            return representationType;
        }
        return GENERIC;
    }

    @Deprecated
    public static RepresentationType lookup(MediaType mediaType) {
        if (mediaType != null) {
            for (RepresentationType representationType : RepresentationType.values()) {
                if (!representationType.matches(mediaType)) continue;
                return representationType;
            }
        }
        return GENERIC;
    }

    public boolean matches(MediaType mediaType) {
        return this.matchesXmlProfile(mediaType) || this.matchesJsonProfile(mediaType);
    }

    public boolean matchesXmlProfile(MediaType mediaType) {
        MediaType xmlCandidate = this.getXmlMediaType();
        if (xmlCandidate == null) {
            return false;
        }
        return this.matchesProfile(mediaType, xmlCandidate);
    }

    public boolean matchesJsonProfile(MediaType mediaType) {
        MediaType jsonCandidate = this.getJsonMediaType();
        return this.matchesProfile(mediaType, jsonCandidate);
    }

    private boolean matchesProfile(MediaType mediaType, MediaType candidate) {
        if (!candidate.getType().equals(mediaType.getType())) {
            return false;
        }
        if (!candidate.getSubtype().equals(mediaType.getSubtype())) {
            return false;
        }
        String candidateProfile = (String)candidate.getParameters().get("profile");
        String mediaTypeProfile = (String)mediaType.getParameters().get("profile");
        return candidateProfile == null || candidateProfile.equals(mediaTypeProfile);
    }

    public MediaType matchesXmlProfileWithParameter(List<MediaType> mediaTypes, String parameterKey) {
        for (MediaType mediaType : mediaTypes) {
            if (!this.matchesXmlProfile(mediaType)) continue;
            String paramValue = (String)mediaType.getParameters().get(parameterKey);
            if (paramValue == null) {
                return null;
            }
            return mediaType;
        }
        return null;
    }

    public MediaType matchesJsonProfileWithParameter(List<MediaType> mediaTypes, String parameterKey) {
        for (MediaType mediaType : mediaTypes) {
            if (!this.matchesJsonProfile(mediaType)) continue;
            String paramValue = (String)mediaType.getParameters().get(parameterKey);
            if (paramValue == null) {
                return null;
            }
            return mediaType;
        }
        return null;
    }

    public static Parser<RepresentationType> parser() {
        return new Parser<RepresentationType>(){

            @Override
            public RepresentationType valueOf(String str) {
                return RepresentationType.lookup(str);
            }

            @Override
            public String asString(RepresentationType t) {
                return t.getName();
            }
        };
    }
}

