/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.xeditable;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapJavascriptBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.xeditable.XEditableOptions;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.xeditable.css.XEditableCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.xeditable.js.XEditableJsReference;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.StringValue;

public class XEditableBehavior
extends BootstrapJavascriptBehavior {
    private final XEditableOptions options;
    private AjaxEventBehavior saveListener;
    private AjaxEventBehavior hiddenListener;

    public XEditableBehavior() {
        this(new XEditableOptions());
    }

    public XEditableBehavior(XEditableOptions options) {
        this.options = (XEditableOptions)((Object)Args.notNull((Object)((Object)options), (String)"options"));
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)XEditableCssReference.INSTANCE));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)XEditableJsReference.INSTANCE));
        response.render((HeaderItem)JQuery.$((Component)component).chain((CharSequence)"editable", (Config)this.options, new Config[0]).asDomReadyScript());
    }

    protected void onSave(AjaxRequestTarget target, String value) {
    }

    protected void onHidden(AjaxRequestTarget target, Reason reason) {
    }

    public void bind(Component component) {
        super.bind(component);
        this.saveListener = this.newSaveListener();
        component.add(new Behavior[]{this.saveListener});
        if (this.wantOnHiddenNotifications()) {
            this.hiddenListener = this.newHiddenListener();
            component.add(new Behavior[]{this.hiddenListener});
        }
    }

    public void unbind(Component component) {
        component.remove(new Behavior[]{this.saveListener});
        this.saveListener = null;
        if (this.hiddenListener != null) {
            component.remove(new Behavior[]{this.hiddenListener});
            this.hiddenListener = null;
        }
        super.unbind(component);
    }

    protected AjaxEventBehavior newSaveListener() {
        return new AjaxEventBehavior("save"){

            protected void onEvent(AjaxRequestTarget target) {
                StringValue newValue = RequestCycle.get().getRequest().getRequestParameters().getParameterValue("newValue");
                XEditableBehavior.this.onSave(target, newValue.toString());
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getDynamicExtraParameters().add("return [{'name':'newValue', 'value': attrs.event.extraData.newValue}]");
            }
        };
    }

    protected AjaxEventBehavior newHiddenListener() {
        return new AjaxEventBehavior("hidden"){

            protected void onEvent(AjaxRequestTarget target) {
                StringValue reason = RequestCycle.get().getRequest().getRequestParameters().getParameterValue("reason");
                XEditableBehavior.this.onHidden(target, Reason.valueOf(reason.toString().toUpperCase()));
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getDynamicExtraParameters().add("return [{'name':'reason', 'value': attrs.event.extraData}]");
            }
        };
    }

    protected boolean wantOnHiddenNotifications() {
        return false;
    }

    public static enum Reason {
        SAVE,
        CANCEL,
        ONBLUR,
        NOCHANGE,
        MANUAL;

    }
}

