/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.contextmenu;

import com.google.common.base.Optional;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.util.References;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.contextmenu.ContextMenuJavaScriptReference;
import de.agilecoders.wicket.jquery.JQuery;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.JavaScriptResourceReference;

public abstract class ContextMenu<T>
extends GenericPanel<T> {
    private Optional<Component> assignedComponent = Optional.absent();

    protected ContextMenu(String markupId) {
        this(markupId, null);
    }

    public ContextMenu(String markupId, IModel<T> model) {
        super(markupId, model);
        this.setOutputMarkupPlaceholderTag(true);
        BootstrapResourcesBehavior.addTo((Component)this);
        this.add(new Behavior[]{new CssClassNameAppender(new String[]{"context-menu"})});
        this.add(new Component[]{this.createContent("content")});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (this.isAssigned()) {
            References.renderWithFilter((IHeaderResponse)response, (JavaScriptResourceReference[])new JavaScriptResourceReference[]{ContextMenuJavaScriptReference.instance()});
            response.render((HeaderItem)JQuery.$((Component)((Component)this.assignedComponent.get())).chain((CharSequence)"contextmenu").asDomReadyScript());
        }
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setVisible(this.isAssigned());
    }

    public final boolean isAssigned() {
        return this.assignedComponent.isPresent();
    }

    public ContextMenu assignTo(Component component) {
        this.assignedComponent = Optional.fromNullable((Object)component);
        component.setOutputMarkupId(true);
        component.add(new Behavior[]{new AttributeModifier("data-toggle", (Serializable)((Object)"context"))});
        component.add(new Behavior[]{new AttributeModifier("data-target", (Serializable)((Object)("#" + Strings2.getMarkupId((Component)this))))});
        return this;
    }

    protected abstract Component createContent(String var1);
}

