/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.PartWriterCallback;

public class FileSystemResource
extends AbstractResource {
    private static final long serialVersionUID = 1L;
    private Path path;

    public FileSystemResource(Path path) {
        this.path = path;
    }

    public FileSystemResource() {
    }

    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        return this.createResourceResponse(this.path);
    }

    protected AbstractResource.ResourceResponse createResourceResponse(Path path) {
        try {
            if (path == null) {
                throw new WicketRuntimeException("Please override #newResourceResponse() and provide a path if using a constructor which doesn't take one as argument.");
            }
            this.path = path;
            long size = this.getSize();
            AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
            resourceResponse.setContentType(this.getMimeType());
            resourceResponse.setAcceptRange(AbstractResource.ContentRangeType.BYTES);
            resourceResponse.setContentLength(size);
            RequestCycle cycle = RequestCycle.get();
            Long startbyte = (Long)cycle.getMetaData(CONTENT_RANGE_STARTBYTE);
            Long endbyte = (Long)cycle.getMetaData(CONTENT_RANGE_ENDBYTE);
            resourceResponse.setWriteCallback(new PartWriterCallback(this.getInputStream(), size, startbyte, endbyte));
            return resourceResponse;
        }
        catch (IOException e) {
            throw new WicketRuntimeException("An error occured while processing the media resource response", e);
        }
    }

    protected long getSize() throws IOException {
        return Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]).size();
    }

    protected String getMimeType() throws IOException {
        String mimeType = null;
        if (Application.exists()) {
            mimeType = Application.get().getMimeType(this.path.getFileName().toString());
        }
        if (mimeType == null) {
            mimeType = Files.probeContentType(this.path);
        }
        return mimeType;
    }

    protected InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }
}

